/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.plugin;

import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.DataContainerKey;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class MinecartModelArmaturePlugin
extends ArmaturePlugin {
    private static final DataContainerKey<Boolean> IS_FLAPPED = DataContainerKey.of("isFlapped", Boolean.class, () -> false);

    public MinecartModelArmaturePlugin(ArmatureTransformerContext context) {
    }

    @Override
    public void activate(Entity entity, ArmaturePlugin.Context context) {
        AbstractMinecart minecart = (AbstractMinecart)entity;
        IPoseStack poseStack = context.poseStack();
        if (this.isFlapped(minecart, context.partialTicks(), context.renderData())) {
            poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -0.125f, 0.0f);
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
    }

    private boolean isFlapped(AbstractMinecart entity, float partialTicks, EntityRenderData renderData) {
        BlockState blockState;
        int k;
        int j;
        int i;
        Vec3 delta = entity.getDeltaMovement();
        double dx = delta.x();
        double dz = delta.z();
        if (dx == 0.0 && dz == 0.0) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        Level level = PropertyProvider.getLevel((Entity)entity);
        if (level.getBlockState(new BlockPos(i = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.xOld, entity.getX())), (j = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.yOld, entity.getY()))) - 1, k = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.zOld, entity.getZ())))).is(BlockTags.RAILS)) {
            --j;
        }
        if (!BaseRailBlock.isRail((BlockState)(blockState = level.getBlockState(new BlockPos(i, j, k))))) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        RailShape shape = (RailShape)blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty());
        boolean result = this.isFlapped(shape, dx, dz);
        renderData.setAssociatedObject(IS_FLAPPED, result);
        return result;
    }

    private boolean isFlapped(RailShape shape, double x, double z) {
        double eps = 0.001;
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case RailShape.NORTH_WEST, RailShape.NORTH_EAST -> {
                if (z < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.SOUTH_EAST, RailShape.SOUTH_WEST -> {
                if (z > eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.NORTH_SOUTH -> {
                if (z < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.EAST_WEST -> {
                if (x < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST -> {
                if (x < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_NORTH, RailShape.ASCENDING_SOUTH -> z < -eps;
        };
    }
}

