/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.crafting.recipe;

import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public abstract class SkinningRecipe {
    protected SkinType skinType;

    public SkinningRecipe(SkinType skinType) {
        this.skinType = skinType;
    }

    public void apply(Container inventory) {
        ItemStack skinStack = ItemStack.EMPTY;
        ItemStack targetStack = ItemStack.EMPTY;
        int size = inventory.getContainerSize();
        for (int i = 1; i < size; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (this.isValidSkin(itemStack)) {
                skinStack = itemStack;
                continue;
            }
            if (this.isValidTarget(itemStack)) {
                targetStack = itemStack;
                continue;
            }
            return;
        }
        if (targetStack.isEmpty() || skinStack.isEmpty()) {
            return;
        }
        this.shrink(targetStack, skinStack);
    }

    public ItemStack test(Container inventory, SkinDescriptor.Options options) {
        ItemStack skinStack = ItemStack.EMPTY;
        ItemStack targetStack = ItemStack.EMPTY;
        int size = inventory.getContainerSize();
        for (int i = 1; i < size; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (this.isValidSkin(itemStack)) {
                skinStack = itemStack;
                continue;
            }
            if (this.isValidTarget(itemStack)) {
                targetStack = itemStack;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (targetStack.isEmpty() || skinStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.build(targetStack, skinStack, options);
    }

    protected void shrink(ItemStack targetStack, ItemStack skinStack) {
        targetStack.shrink(1);
        skinStack.shrink(1);
    }

    protected ItemStack build(ItemStack targetStack, ItemStack skinStack, SkinDescriptor.Options options) {
        SkinDescriptor skin = ComponentAPI.getOrDefault(skinStack, (IDataComponentType)ModDataComponents.SKIN.get(), SkinDescriptor.EMPTY);
        ItemStack newItemStack = targetStack.copy();
        newItemStack.setCount(1);
        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.SKIN.get(), skin.withOptions(options));
        return newItemStack;
    }

    protected boolean isValidSkin(ItemStack itemStack) {
        return ModItems.SKIN.get() == itemStack.getItem() && SkinDescriptor.of(itemStack).type() == this.skinType;
    }

    protected boolean isValidTarget(ItemStack itemStack) {
        return ModItems.SKIN.get() != itemStack.getItem();
    }
}

