/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.network.CustomPacket;

public class GenericProperty<S, T> {
    protected int ordinal;
    protected GenericProperties<S> owner;
    protected IEntitySerializer<T> serializer;
    protected Function<S, T> getter;
    protected BiConsumer<S, T> setter;

    public CustomPacket buildPacket(S source, T value) {
        return this.owner.encodePacket(this, value, source);
    }

    public void set(S source, T value) {
        if (this.setter != null) {
            this.setter.accept(source, value);
        }
    }

    public T get(S source) {
        if (this.getter != null) {
            return this.getter.apply(source);
        }
        return null;
    }

    public T getOrDefault(S source, T defaultValue) {
        T value = this.get(source);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String toString() {
        return String.valueOf(this.ordinal);
    }
}

