/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import moe.plushie.armourers_workshop.api.common.IEntityDataBuilder;
import moe.plushie.armourers_workshop.api.common.IEntityHandler;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractLivingEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.option.MannequinToolOptions;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntitySerializers;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MannequinEntity
extends AbstractLivingEntity.ArmorStand
implements IEntityHandler,
IDataSerializable.Mutable {
    public static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    public static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);
    public static final EntityDimensions BABY_DIMENSIONS = EntityDimensions.scalable((float)0.5f, (float)1.0f).withEyeHeight(0.88f);
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.scalable((float)0.6f, (float)1.88f).withEyeHeight(1.62f);
    public static final EntityDataAccessor<Boolean> DATA_IS_CHILD = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_FLYING = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_GHOST = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_VISIBLE = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> DATA_EXTRA_RENDERER = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_NO_GRAVITY = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<EntityTextureDescriptor> DATA_TEXTURE = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE);
    public static final EntityDataAccessor<EntityTextureDescriptor.Model> DATA_TEXTURE_MODEL = SynchedEntityData.defineId(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE_MODEL);
    private boolean isDropEquipment = false;
    private AABB boundingBoxForCulling;

    public MannequinEntity(EntityType<? extends MannequinEntity> entityType, Level level) {
        super((EntityType<? extends AbstractLivingEntity.ArmorStand>)entityType, level);
    }

    @Override
    protected void defineSynchedData(IEntityDataBuilder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHILD, false);
        builder.define(DATA_IS_FLYING, false);
        builder.define(DATA_IS_GHOST, false);
        builder.define(DATA_IS_VISIBLE, true);
        builder.define(DATA_EXTRA_RENDERER, true);
        builder.define(DATA_NO_GRAVITY, true);
        builder.define(DATA_SCALE, Float.valueOf(1.0f));
        builder.define(DATA_TEXTURE, EntityTextureDescriptor.EMPTY);
        builder.define(DATA_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.deserialize(new TagSerializer(tag));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.serialize(new TagSerializer(tag));
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.IS_SMALL, (Boolean)this.entityData.get(DATA_IS_CHILD));
        serializer.write(CodingKeys.IS_FLYING, (Boolean)this.entityData.get(DATA_IS_FLYING));
        serializer.write(CodingKeys.IS_GHOST, (Boolean)this.entityData.get(DATA_IS_GHOST));
        serializer.write(CodingKeys.IS_VISIBLE, (Boolean)this.entityData.get(DATA_IS_VISIBLE));
        serializer.write(CodingKeys.EXTRA_RENDER, (Boolean)this.entityData.get(DATA_EXTRA_RENDERER));
        serializer.write(CodingKeys.NO_GRAVITY, (Boolean)this.entityData.get(DATA_NO_GRAVITY));
        serializer.write(CodingKeys.SCALE, (Float)this.entityData.get(DATA_SCALE));
        serializer.write(CodingKeys.TEXTURE, (EntityTextureDescriptor)this.entityData.get(DATA_TEXTURE));
        serializer.write(CodingKeys.TEXTURE_MODEL, (EntityTextureDescriptor.Model)((Object)this.entityData.get(DATA_TEXTURE_MODEL)));
        serializer.write(CodingKeys.POSE, this.saveCustomPose());
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.entityData.set(DATA_IS_CHILD, (Object)serializer.read(CodingKeys.IS_SMALL));
        this.entityData.set(DATA_IS_FLYING, (Object)serializer.read(CodingKeys.IS_FLYING));
        this.entityData.set(DATA_IS_GHOST, (Object)serializer.read(CodingKeys.IS_GHOST));
        this.entityData.set(DATA_IS_VISIBLE, (Object)serializer.read(CodingKeys.IS_VISIBLE));
        this.entityData.set(DATA_EXTRA_RENDERER, (Object)serializer.read(CodingKeys.EXTRA_RENDER));
        this.entityData.set(DATA_NO_GRAVITY, (Object)serializer.read(CodingKeys.NO_GRAVITY));
        this.entityData.set(DATA_SCALE, (Object)serializer.read(CodingKeys.SCALE));
        this.entityData.set(DATA_TEXTURE, (Object)serializer.read(CodingKeys.TEXTURE));
        this.entityData.set(DATA_TEXTURE_MODEL, (Object)serializer.read(CodingKeys.TEXTURE_MODEL));
        this.readCustomPose(serializer.read(CodingKeys.POSE));
        this.refreshDimensions();
        this.refreshPhysics();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataParameter) {
        if (DATA_IS_CHILD.equals(dataParameter)) {
            this.refreshDimensions();
        }
        if (DATA_SCALE.equals(dataParameter)) {
            this.refreshDimensions();
        }
        if (DATA_NO_GRAVITY.equals(dataParameter)) {
            this.refreshPhysics();
        }
        super.onSyncedDataUpdated(dataParameter);
    }

    public boolean isModelVisible() {
        return (Boolean)this.entityData.get(DATA_IS_VISIBLE);
    }

    public void setModelVisible(boolean value) {
        this.entityData.set(DATA_IS_VISIBLE, (Object)value);
    }

    public float getScale() {
        return ((Float)this.entityData.get(DATA_SCALE)).floatValue();
    }

    public boolean isSmall() {
        return (Boolean)this.entityData.get(DATA_IS_CHILD);
    }

    public boolean isNoGravity() {
        return (Boolean)this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean bl) {
        this.entityData.set(DATA_NO_GRAVITY, (Object)bl);
    }

    public boolean isFakeFlying() {
        return (Boolean)this.entityData.get(DATA_IS_FLYING);
    }

    public boolean canBeCollidedWith() {
        return this.isAlive() && (Boolean)this.entityData.get(DATA_IS_GHOST) == false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isMarker()) {
            return MARKER_DIMENSIONS;
        }
        EntityDimensions entitySize = STANDING_DIMENSIONS;
        if (this.isBaby()) {
            entitySize = BABY_DIMENSIONS;
        }
        return entitySize;
    }

    @Override
    public ItemStack getCustomPickResult(HitResult target) {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.MANNEQUIN.get());
        if (EnvironmentExecutorIO.hasControlDown()) {
            CompoundTag entityTag = new CompoundTag();
            entityTag.putString("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            this.addAdditionalSaveData(entityTag);
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
        }
        return itemStack;
    }

    public void setYBodyRot(float f) {
        super.setYBodyRot(f);
        this.setYRot(f);
        this.yBodyRot = f;
    }

    public void setPos(double d, double e, double f) {
        super.setPos(d, e, f);
        this.boundingBoxForCulling = null;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.isDropEquipment = false;
        boolean flag = this.isAlive();
        boolean flag1 = super.hurt(source, amount);
        Level level = PropertyProvider.getLevel((Entity)this);
        if (!this.isDropEquipment && flag != this.isAlive() && level instanceof ServerLevel) {
            this.brokenByAnything((ServerLevel)level, source);
        }
        return flag1;
    }

    public InteractionResult interactAt(Player player, Vec3 pos, InteractionHand hand) {
        if (this.isMarker()) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)ModItems.MANNEQUIN_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (itemStack.is(Items.NAME_TAG)) {
            return itemStack.interactLivingEntity(player, (LivingEntity)this, hand);
        }
        if (player.isSecondaryUseActive()) {
            if (EnvironmentExecutorIO.hasControlDown()) {
                return super.interactAt(player, pos, hand);
            }
            double ry = OpenMath.getAngleDegrees(player.getX(), player.getZ(), this.getX(), this.getZ()) + 90.0;
            Rotations rotations = this.getBodyPose();
            float yRot = this.getYRot();
            this.setBodyPose(new Rotations(rotations.getX(), (float)ry - yRot, rotations.getZ()));
            return InteractionResult.sidedSuccess((boolean)PropertyProvider.getLevel((Entity)this).isClientSide());
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null && wardrobe.isEditable(player)) {
            ((IMenuType)ModMenuTypes.WARDROBE.get()).openMenu(player, wardrobe);
            return InteractionResult.sidedSuccess((boolean)PropertyProvider.getLevel((Entity)this).isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void brokenByPlayer(ServerLevel serverLevel, DamageSource source) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                EntityData entityData = new EntityData();
                entityData.setScale(this.getScale());
                entityData.setTexture(this.getTextureDescriptor());
                Block.popResource((Level)PropertyProvider.getLevel((Entity)this), (BlockPos)this.blockPosition(), (ItemStack)entityData.itemStack());
            }
        }
        this.brokenByAnything(serverLevel, source);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        this.isDropEquipment = true;
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null) {
            wardrobe.dropAll(arg_0 -> ((MannequinEntity)this).spawnAtLocation(arg_0));
        }
    }

    protected void refreshPhysics() {
        this.noPhysics = !this.hasPhysics();
    }

    protected boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getBoundingBoxForCulling() {
        if (this.boundingBoxForCulling != null) {
            return this.boundingBoxForCulling;
        }
        float f = this.getScale();
        this.boundingBoxForCulling = this.getBoundingBox().inflate((double)(f * 3.0f), (double)(f * 2.0f), (double)(f * 2.5f));
        return this.boundingBoxForCulling;
    }

    public EntityTextureDescriptor getTextureDescriptor() {
        return (EntityTextureDescriptor)this.entityData.get(DATA_TEXTURE);
    }

    public void setTextureDescriptor(EntityTextureDescriptor newValue) {
        this.entityData.set(DATA_TEXTURE, (Object)newValue);
    }

    public EntityTextureDescriptor.Model getTextureModel() {
        return (EntityTextureDescriptor.Model)((Object)this.entityData.get(DATA_TEXTURE_MODEL));
    }

    public void setTextureModel(EntityTextureDescriptor.Model newValue) {
        this.entityData.set(DATA_TEXTURE_MODEL, (Object)newValue);
    }

    public boolean isExtraRenderer() {
        return (Boolean)this.entityData.get(DATA_EXTRA_RENDERER);
    }

    public void setExtraRenderer(boolean value) {
        this.entityData.set(DATA_EXTRA_RENDERER, (Object)value);
    }

    public Container getInventory() {
        return new SimpleContainer(new ItemStack[]{this.getMainHandItem(), this.getOffhandItem()}){

            public void setItem(int index, ItemStack itemStack) {
                super.setItem(index, itemStack);
                MannequinEntity.this.setItemSlot(EquipmentSlot.values()[index], itemStack);
            }
        };
    }

    public CompoundTag saveCustomPose() {
        TagSerializer serializer = new TagSerializer();
        serializer.write(CodingKeys.POSE_HEAD, (Rotations)this.entityData.get(DATA_HEAD_POSE));
        serializer.write(CodingKeys.POSE_BODY, (Rotations)this.entityData.get(DATA_BODY_POSE));
        serializer.write(CodingKeys.POSE_LEFT_ARM, (Rotations)this.entityData.get(DATA_LEFT_ARM_POSE));
        serializer.write(CodingKeys.POSE_RIGHT_ARM, (Rotations)this.entityData.get(DATA_RIGHT_ARM_POSE));
        serializer.write(CodingKeys.POSE_LEFT_LEG, (Rotations)this.entityData.get(DATA_LEFT_LEG_POSE));
        serializer.write(CodingKeys.POSE_RIGHT_LEG, (Rotations)this.entityData.get(DATA_RIGHT_LEG_POSE));
        return serializer.tag();
    }

    public void readCustomPose(CompoundTag tag) {
        TagSerializer serializer = new TagSerializer(tag);
        this.setHeadPose(serializer.read(CodingKeys.POSE_HEAD));
        this.setBodyPose(serializer.read(CodingKeys.POSE_BODY));
        this.setLeftArmPose(serializer.read(CodingKeys.POSE_LEFT_ARM));
        this.setRightArmPose(serializer.read(CodingKeys.POSE_RIGHT_ARM));
        this.setLeftLegPose(serializer.read(CodingKeys.POSE_LEFT_LEG));
        this.setRightLegPose(serializer.read(CodingKeys.POSE_RIGHT_LEG));
    }

    public void saveMannequinToolData(CompoundTag entityTag) {
        this.serialize(new TagSerializer(entityTag));
    }

    public void readMannequinToolData(CompoundTag entityTag, ItemStack itemStack) {
        Tag oldValue;
        CompoundTag newEntityTag = new CompoundTag();
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_OPTION).booleanValue()) {
            newEntityTag.merge(entityTag);
            newEntityTag.remove(CodingKeys.SCALE.name());
            newEntityTag.remove(CodingKeys.POSE.name());
            newEntityTag.remove(CodingKeys.TEXTURE.name());
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_SCALE).booleanValue() && (oldValue = entityTag.get(CodingKeys.SCALE.name())) != null) {
            newEntityTag.put(CodingKeys.SCALE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_ROTATION).booleanValue()) {
            oldValue = OptionalAPI.getOptionalCompound(entityTag, CodingKeys.POSE.name()).orElseGet(CompoundTag::new);
            if (ToolAPI.get(itemStack, MannequinToolOptions.MIRROR_MODE).booleanValue() && !oldValue.isEmpty()) {
                TagSerializer poseSerializer = new TagSerializer(oldValue.copy());
                poseSerializer.write(CodingKeys.POSE_HEAD, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_HEAD)));
                poseSerializer.write(CodingKeys.POSE_BODY, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_BODY)));
                poseSerializer.write(CodingKeys.POSE_LEFT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_ARM)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_ARM)));
                poseSerializer.write(CodingKeys.POSE_LEFT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_LEG)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_LEG)));
                oldValue = poseSerializer.tag();
            }
            newEntityTag.put(CodingKeys.POSE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_TEXTURE).booleanValue() && (oldValue = entityTag.get(CodingKeys.TEXTURE.name())) != null) {
            newEntityTag.put(CodingKeys.TEXTURE.name(), oldValue);
        }
        this.deserialize(new TagSerializer(newEntityTag));
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Boolean> IS_SMALL = IDataSerializerKey.create("Small", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_FLYING = IDataSerializerKey.create("Flying", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_GHOST = IDataSerializerKey.create("Ghost", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_VISIBLE = IDataSerializerKey.create("ModelVisible", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> EXTRA_RENDER = IDataSerializerKey.create("ExtraRender", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> NO_GRAVITY = IDataSerializerKey.create("NoGravity", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Float> SCALE = IDataSerializerKey.create("Scale", IDataCodec.FLOAT, Float.valueOf(1.0f));
        public static final IDataSerializerKey<EntityTextureDescriptor> TEXTURE = IDataSerializerKey.create("Texture", EntityTextureDescriptor.CODEC, EntityTextureDescriptor.EMPTY);
        public static final IDataSerializerKey<EntityTextureDescriptor.Model> TEXTURE_MODEL = IDataSerializerKey.create("TextureModel", DataSerializers.ENTITY_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
        public static final IDataSerializerKey<CompoundTag> POSE = IDataSerializerKey.create("Pose", IDataCodec.COMPOUND_TAG, new CompoundTag());
        public static final IDataSerializerKey<Rotations> POSE_HEAD = IDataSerializerKey.create("Head", EntityData.ROTATIONS_CODEC, DEFAULT_HEAD_POSE);
        public static final IDataSerializerKey<Rotations> POSE_BODY = IDataSerializerKey.create("Body", EntityData.ROTATIONS_CODEC, DEFAULT_BODY_POSE);
        public static final IDataSerializerKey<Rotations> POSE_LEFT_ARM = IDataSerializerKey.create("LeftArm", EntityData.ROTATIONS_CODEC, DEFAULT_LEFT_ARM_POSE);
        public static final IDataSerializerKey<Rotations> POSE_RIGHT_ARM = IDataSerializerKey.create("RightArm", EntityData.ROTATIONS_CODEC, DEFAULT_RIGHT_ARM_POSE);
        public static final IDataSerializerKey<Rotations> POSE_LEFT_LEG = IDataSerializerKey.create("LeftLeg", EntityData.ROTATIONS_CODEC, DEFAULT_LEFT_LEG_POSE);
        public static final IDataSerializerKey<Rotations> POSE_RIGHT_LEG = IDataSerializerKey.create("RightLeg", EntityData.ROTATIONS_CODEC, DEFAULT_RIGHT_LEG_POSE);

        private CodingKeys() {
        }
    }

    public static class EntityData {
        private static final IDataCodec<Rotations> ROTATIONS_CODEC = IDataCodec.FLOAT.listOf().xmap(it -> new Rotations(((Float)it.get(0)).floatValue(), ((Float)it.get(1)).floatValue(), ((Float)it.get(2)).floatValue()), it -> Collections.newList(Float.valueOf(it.getX()), Float.valueOf(it.getY()), Float.valueOf(it.getZ())));
        private final TagSerializer serializer;

        public EntityData() {
            this.serializer = new TagSerializer();
        }

        public EntityData(CompoundTag tag) {
            this.serializer = new TagSerializer(tag);
        }

        private static Rotations mirror(Rotations rot) {
            return new Rotations(rot.getX(), -rot.getY(), -rot.getZ());
        }

        public void setScale(float scale) {
            this.serializer.write(CodingKeys.SCALE, Float.valueOf(scale));
        }

        public float scale() {
            return this.serializer.read(CodingKeys.SCALE).floatValue();
        }

        public void setTexture(EntityTextureDescriptor texture) {
            this.serializer.write(CodingKeys.TEXTURE, texture);
        }

        public EntityTextureDescriptor texture() {
            return this.serializer.read(CodingKeys.TEXTURE);
        }

        public boolean isSmall() {
            return this.serializer.read(CodingKeys.IS_SMALL);
        }

        public CompoundTag entityTag() {
            CompoundTag entityTag = this.serializer.tag().copy();
            if (!entityTag.isEmpty()) {
                entityTag.putString("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            }
            return entityTag;
        }

        public ItemStack itemStack() {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.MANNEQUIN.get());
            CompoundTag entityTag = this.entityTag();
            if (!entityTag.isEmpty()) {
                ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
            }
            return itemStack;
        }
    }
}

