/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import java.util.Collections;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractLivingEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SeatEntity
extends AbstractLivingEntity
implements IDataSerializable.Mutable {
    private int holdingTick;
    private BlockPos blockPos = BlockPos.ZERO;

    public SeatEntity(EntityType<? extends SeatEntity> entityType, Level level) {
        super(entityType, level);
        this.setInvisible(true);
        this.setInvulnerable(true);
        this.setYBodyRot(0.0f);
        this.holdingTick = ModConfig.Client.prefersSeatHoldingTick;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.deserialize(new TagSerializer(tag));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.serialize(new TagSerializer(tag));
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.REFER, this.blockPos);
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.blockPos = serializer.read(CodingKeys.REFER);
    }

    public void tick() {
        super.tick();
        if (!PropertyProvider.getLevel((Entity)this).isClientSide()) {
            this.autoKill();
        }
    }

    public void travel(Vec3 local) {
        if (this.isAlive() && !this.getPassengers().isEmpty()) {
            Entity passenger = (Entity)this.getPassengers().get(0);
            this.setYBodyRot(passenger.getYRot());
        }
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
    }

    public void autoKill() {
        if (this.holdingTick > 0) {
            --this.holdingTick;
        }
        if (this.holdingTick <= 0 && this.isAlive() && !this.isWorking()) {
            this.kill();
        }
    }

    protected void removePassenger(Entity entity) {
        super.removePassenger(entity);
        this.holdingTick = ModConfig.Client.prefersSeatHoldingTick;
    }

    public boolean isWorking() {
        if (this.getPassengers().isEmpty()) {
            return false;
        }
        return PropertyProvider.getLevel((Entity)this) != null && this.blockPos != null && PropertyProvider.getLevel((Entity)this).getBlockEntity(this.blockPos) instanceof SkinnableBlockEntity;
    }

    public void setYBodyRot(float f) {
        super.setYBodyRot(f);
        this.setYRot(f);
        this.yRotO = f;
        this.yHeadRot = f;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public HumanoidArm getMainArm() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double p_70112_1_) {
        return false;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Collections.emptyList();
    }

    public ItemStack getItemBySlot(EquipmentSlot p_184582_1_) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotType, ItemStack itemStack) {
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<BlockPos> REFER = IDataSerializerKey.create("Refer", IDataCodec.BLOCK_POS, BlockPos.ZERO);

        private CodingKeys() {
        }
    }
}

