/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LinkingToolItem
extends FlavouredItem
implements IItemHandler,
IItemPropertiesProvider {
    public LinkingToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> {
            if (ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get())) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    @Override
    public InteractionResult useOnFirst(ItemStack itemStack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level.isClientSide() || player == null) {
            return InteractionResult.SUCCESS;
        }
        GlobalPos linkedPos = (GlobalPos)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
        SkinnableBlockEntity blockEntity = this.getTitleEntity(level, context.getClickedPos());
        if (blockEntity != null && player.isSecondaryUseActive()) {
            blockEntity.setLinkedPos(null);
            player.sendSystemMessage((Component)Component.translatable((String)"inventory.armourers_workshop.linking-tool.clear"));
            return InteractionResult.SUCCESS;
        }
        if (linkedPos != null) {
            if (Objects.equals(level.dimension(), linkedPos.dimension())) {
                int maxDistance = ModConfig.Common.maxLinkDistance;
                if (maxDistance > 0 && !context.getClickedPos().closerThan((Vec3i)linkedPos.pos(), (double)maxDistance + 0.5)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"inventory.armourers_workshop.linking-tool.targetTooFar"));
                    return InteractionResult.FAIL;
                }
            } else if (!ModConfig.Common.enableLinkDimensional) {
                player.sendSystemMessage((Component)Component.translatable((String)"inventory.armourers_workshop.linking-tool.targetWrongDimensions"));
                return InteractionResult.FAIL;
            }
            ComponentAPI.remove(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
            if (blockEntity != null) {
                blockEntity.setLinkedPos(linkedPos);
                player.sendSystemMessage((Component)Component.translatable((String)"inventory.armourers_workshop.linking-tool.finish"));
                return InteractionResult.SUCCESS;
            }
            player.sendSystemMessage((Component)Component.translatable((String)"inventory.armourers_workshop.linking-tool.fail"));
            return InteractionResult.SUCCESS;
        }
        if (blockEntity != null) {
            player.sendSystemMessage((Component)Component.translatable((String)"inventory.armourers_workshop.linking-tool.linkedToSkinnable"));
            return InteractionResult.FAIL;
        }
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get(), GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)context.getClickedPos()));
        player.sendSystemMessage((Component)Component.translatable((String)"inventory.armourers_workshop.linking-tool.start"));
        return InteractionResult.SUCCESS;
    }

    private SkinnableBlockEntity getTitleEntity(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            return (SkinnableBlockEntity)blockEntity;
        }
        return null;
    }
}

