/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SkinItem
extends BlockItem
implements IItemPropertiesProvider {
    public SkinItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinSlotType slotType = SkinSlotType.byType(descriptor.type());
        if (descriptor.isEmpty() || slotType == null) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
        if (wardrobe == null || !wardrobe.isEditable(player) || !wardrobe.isSupported(slotType)) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        int slot = wardrobe.getFreeSlot(slotType);
        if (!wardrobe.getItem(slotType, slot).isEmpty()) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        ItemStack resultStack = itemStack.copy();
        wardrobe.setItem(slotType, slot, resultStack.split(1));
        wardrobe.broadcast();
        player.setItemInHand(hand, resultStack);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public InteractionResult place(BlockPlaceContext context) {
        ItemStack itemStack = context.getItemInHand();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.type() != SkinTypes.BLOCK) {
            return InteractionResult.PASS;
        }
        return super.place((BlockPlaceContext)new SkinBlockPlaceContext((UseOnContext)context));
    }

    public Component getName(ItemStack itemStack) {
        Skin skin = SkinLoader.getInstance().getSkin(itemStack);
        if (skin != null && !skin.customName().trim().isEmpty()) {
            return TranslateUtils.formatted(skin.customName());
        }
        if (skin != null) {
            return TranslateUtils.Name.of(skin.type());
        }
        return super.getName(itemStack);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("loading"), (itemStack, level, entity, id) -> {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
            if (bakedSkin != null) {
                return 0.0f;
            }
            return (float)descriptor.type().id() / 1000.0f;
        });
    }
}

