/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.menu.SkinSlot;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinWardrobeMenu
extends AbstractContainerMenu {
    private final Player player;
    private final SkinWardrobe wardrobe;
    private final ArrayList<ItemStack> lastSyncSlot = new ArrayList();
    private final ArrayList<Slot> customSlots = new ArrayList();
    private final int slotsX = 83;
    private final int slotsY = 27;
    private Group group = null;

    public SkinWardrobeMenu(MenuType<?> menuType, int containerId, Inventory inventory, SkinWardrobe wardrobe) {
        super(menuType, containerId);
        this.wardrobe = wardrobe;
        this.player = inventory.player;
        this.addPlayerSlots((Container)inventory, 59, 168, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addSkinSlots(SkinSlotType.HEAD, Group.SKINS, 0, 0);
        this.addSkinSlots(SkinSlotType.CHEST, Group.SKINS, 0, 1);
        this.addSkinSlots(SkinSlotType.LEGS, Group.SKINS, 0, 2);
        this.addSkinSlots(SkinSlotType.FEET, Group.SKINS, 0, 3);
        this.addSkinSlots(SkinSlotType.WINGS, Group.SKINS, 0, 4);
        this.addEquipmentSlots(Group.SKINS, 0, 5);
        this.addSkinSlots(SkinSlotType.OUTFIT, Group.OUTFITS, 0, 0);
        this.addSkinSlots(SkinSlotType.BACKPACK, Group.OUTFITS, 0, 5);
        this.addSkinSlots(SkinSlotType.HORSE, Group.UNKNOWN, 0, 0);
        this.addSkinSlots(SkinSlotType.DYE, Group.DYES, 0, 0);
        this.addMannequinSlots(Group.SKINS, 0, 5);
    }

    protected void addEquipmentSlots(Group group, int column, int row) {
        SkinSlotType[] slotTypes = new SkinSlotType[]{SkinSlotType.SWORD, SkinSlotType.SHIELD, SkinSlotType.BOW, SkinSlotType.TRIDENT, null, SkinSlotType.PICKAXE, SkinSlotType.AXE, SkinSlotType.SHOVEL, SkinSlotType.HOE};
        boolean hasContents = false;
        for (SkinSlotType slotType : slotTypes) {
            if (slotType != null) {
                int count = this.wardrobe.getUnlockedSize(slotType);
                if (count <= 0) continue;
                hasContents = true;
                this.addSkinSlots(slotType, group, column, row);
                column += count;
                continue;
            }
            if (!hasContents) continue;
            ++column;
        }
    }

    protected void addMannequinSlots(Group group, int column, int row) {
        Entity entity = this.wardrobe.entity();
        if (entity instanceof MannequinEntity) {
            MannequinEntity entity2 = (MannequinEntity)entity;
            Container inventory = entity2.getInventory();
            int size = inventory.getContainerSize();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                int x = 83 + (column + (size - i - 1)) * 19;
                int y = 27 + row * 19;
                SkinSlot slot = this.addGroupSlot(inventory, i, x, y, group, new SkinSlotType[0]);
                this.customSlots.add(slot);
            }
        }
    }

    protected void addSkinSlots(SkinSlotType slotType, Group group, int column, int row) {
        int index = slotType.index();
        int size = this.wardrobe.getUnlockedSize(slotType);
        Container inventory = this.wardrobe.inventory();
        for (int i = 0; i < size; ++i) {
            int x = 83 + (column + i) * 19;
            int y = 27 + row * 19;
            SkinSlot slot = this.addGroupSlot(inventory, index + i, x, y, group, slotType);
            this.customSlots.add(slot);
        }
    }

    protected SkinSlot addGroupSlot(Container inventory, int index, int x, int y, final Group group, SkinSlotType ... slotTypes) {
        SkinSlot slot = new SkinSlot(inventory, index, x, y, slotTypes){

            public boolean isActive() {
                return SkinWardrobeMenu.this.group() == group;
            }

            @Override
            public boolean mayPlace(ItemStack itemStack) {
                if (ModConfig.Common.onlySkinIntoSlots && !itemStack.is((Item)ModItems.SKIN.get())) {
                    return false;
                }
                return super.mayPlace(itemStack);
            }
        };
        this.addSlot(slot);
        return slot;
    }

    public List<Slot> customSlots() {
        return this.customSlots;
    }

    public void forEachCustomSlots(Consumer<Slot> consumer) {
        for (Slot slot : this.customSlots) {
            if (!slot.isActive()) continue;
            consumer.accept(slot);
        }
    }

    public boolean stillValid(Player player) {
        Entity entity = this.entity();
        if (entity == null || !entity.isAlive() || !this.wardrobe.isEditable(player)) {
            return false;
        }
        return entity.distanceToSqr(player.getX(), player.getY(), player.getZ()) <= 64.0;
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = slot.getItem();
        if (slot instanceof SkinSlot) {
            if (!this.moveItemStackTo(itemStack, 9, 36, false) && !this.moveItemStackTo(itemStack, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            slot.set(ItemStack.EMPTY);
            return itemStack.copy();
        }
        SkinSlotType slotType = SkinSlotType.byItem(itemStack);
        if (slotType != null && this.wardrobe.isSupported(slotType)) {
            int startIndex = this.getFreeSlot(slotType);
            if (!this.moveItemStackTo(itemStack, startIndex, startIndex + 1, false)) {
                return ItemStack.EMPTY;
            }
            slot.set(ItemStack.EMPTY);
            return itemStack.copy();
        }
        if (this.wardrobe.entity() instanceof MannequinEntity) {
            int startIndex = this.getFreeSlot(SkinSlotType.ANY);
            if (!this.moveItemStackTo(itemStack, startIndex, startIndex + 1, false)) {
                return ItemStack.EMPTY;
            }
            slot.set(ItemStack.EMPTY);
            return itemStack.copy();
        }
        return ItemStack.EMPTY;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (PropertyProvider.getLevel((Entity)this.player).isClientSide()) {
            return;
        }
        if (this.lastSyncSlot.size() != this.slots.size()) {
            this.lastSyncSlot.ensureCapacity(this.slots.size());
            this.slots.forEach(s -> this.lastSyncSlot.add(s.getItem()));
            return;
        }
        int changes = 0;
        for (int index = 0; index < this.slots.size(); ++index) {
            if (index < 36) continue;
            ItemStack newItemStack = ((Slot)this.slots.get(index)).getItem();
            if (this.lastSyncSlot.get(index).equals(newItemStack)) continue;
            this.lastSyncSlot.set(index, newItemStack);
            ++changes;
        }
        if (changes != 0) {
            ModLog.debug("observer slots has {} changes, sync to players", changes);
            this.wardrobe.broadcast();
        }
    }

    public boolean shouldRenderInventory() {
        return this.group != null && this.group.shouldRenderInventory();
    }

    private int getFreeSlot(SkinSlotType slotType) {
        for (Slot slot : this.slots) {
            if (!(slot instanceof SkinSlot)) continue;
            SkinSlot slot1 = (SkinSlot)slot;
            if (slot.hasItem() || !slot1.slotTypes().contains((Object)slotType) && !slot1.slotTypes().isEmpty()) continue;
            return slot1.index;
        }
        return 0;
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public SkinWardrobe wardrobe() {
        return this.wardrobe;
    }

    @Nullable
    public Entity entity() {
        return this.wardrobe.entity();
    }

    public static enum Group {
        SKINS(true, 99),
        OUTFITS(true, 99),
        UNKNOWN(true, 99),
        DYES(true, 99),
        COLORS(false, 99);

        private final boolean exchanges;
        private final int extendedHeight;

        private Group(boolean exchanges, int extendedHeight) {
            this.exchanges = exchanges;
            this.extendedHeight = extendedHeight;
        }

        public boolean shouldRenderInventory() {
            return this.exchanges;
        }

        public int extendedHeight() {
            return this.extendedHeight;
        }
    }
}

