/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModLog;

public final class SkinTypes {
    private static final ArrayList<SkinType> ALL_SORTED_TYPES = new ArrayList();
    private static final LinkedHashMap<String, SkinType> ALL_TYPES = new LinkedHashMap();
    public static final IDataCodec<SkinType> CODEC = IDataCodec.STRING.xmap(SkinTypes::byName, SkinType::name);
    public static final SkinType UNKNOWN = SkinTypes.normal(255).part(SkinPartTypes.UNKNOWN).build("unknown");
    public static final SkinType ARMOR_HEAD = SkinTypes.armour(1).part(SkinPartTypes.BIPPED_HEAD).equipmentSlot(OpenEquipmentSlot.HEAD).build("head");
    public static final SkinType ARMOR_CHEST = SkinTypes.armour(2).part(SkinPartTypes.BIPPED_CHEST).part(SkinPartTypes.BIPPED_LEFT_ARM).part(SkinPartTypes.BIPPED_RIGHT_ARM).equipmentSlot(OpenEquipmentSlot.CHEST).build("chest");
    public static final SkinType ARMOR_LEGS = SkinTypes.armour(3).part(SkinPartTypes.BIPPED_LEFT_THIGH).part(SkinPartTypes.BIPPED_RIGHT_THIGH).part(SkinPartTypes.BIPPED_SKIRT).equipmentSlot(OpenEquipmentSlot.LEGS).build("legs");
    public static final SkinType ARMOR_FEET = SkinTypes.armour(4).part(SkinPartTypes.BIPPED_LEFT_FOOT).part(SkinPartTypes.BIPPED_RIGHT_FOOT).equipmentSlot(OpenEquipmentSlot.FEET).build("feet");
    public static final SkinType ARMOR_WINGS = SkinTypes.armour(5).part(SkinPartTypes.BIPPED_LEFT_WING).part(SkinPartTypes.BIPPED_RIGHT_WING).build("wings");
    public static final SkinType OUTFIT = SkinTypes.armour(6).part(ARMOR_HEAD).part(ARMOR_CHEST).part(ARMOR_LEGS).part(ARMOR_FEET).part(ARMOR_WINGS).build("outfit");
    public static final SkinType ITEM_SWORD = SkinTypes.item(7).part(SkinPartTypes.ITEM_SWORD).override(ItemOverrideType.SWORD).build("sword");
    public static final SkinType ITEM_SHIELD = SkinTypes.item(8).part(SkinPartTypes.ITEM_SHIELD).override(ItemOverrideType.SHIELD).build("shield");
    public static final SkinType ITEM_BOW = SkinTypes.item(9).part(SkinPartTypes.ITEM_BOW0).part(SkinPartTypes.ITEM_BOW1).part(SkinPartTypes.ITEM_BOW2).part(SkinPartTypes.ITEM_BOW3).part(SkinPartTypes.ITEM_ARROW).override(ItemOverrideType.BOW).build("bow");
    public static final SkinType ITEM_TRIDENT = SkinTypes.item(17).part(SkinPartTypes.ITEM_TRIDENT).override(ItemOverrideType.TRIDENT).build("trident");
    public static final SkinType ITEM_PICKAXE = SkinTypes.item(10).part(SkinPartTypes.ITEM_PICKAXE).override(ItemOverrideType.PICKAXE).build("pickaxe");
    public static final SkinType ITEM_AXE = SkinTypes.item(11).part(SkinPartTypes.ITEM_AXE).override(ItemOverrideType.AXE).build("axe");
    public static final SkinType ITEM_SHOVEL = SkinTypes.item(12).part(SkinPartTypes.ITEM_SHOVEL).override(ItemOverrideType.SHOVEL).build("shovel");
    public static final SkinType ITEM_HOE = SkinTypes.item(13).part(SkinPartTypes.ITEM_HOE).override(ItemOverrideType.HOE).build("hoe");
    public static final SkinType ITEM = SkinTypes.normal(14).part(SkinPartTypes.ITEM).build("item");
    public static final SkinType BLOCK = SkinTypes.normal(15).part(SkinPartTypes.BLOCK).part(SkinPartTypes.BLOCK_MULTI).build("block");
    public static final SkinType HORSE = SkinTypes.armour(18).part(SkinPartTypes.HORSE_HEAD).part(SkinPartTypes.HORSE_NECK).part(SkinPartTypes.HORSE_CHEST).part(SkinPartTypes.HORSE_RIGHT_FRONT_THIGH).part(SkinPartTypes.HORSE_LEFT_FRONT_THIGH).part(SkinPartTypes.HORSE_RIGHT_FRONT_LEG).part(SkinPartTypes.HORSE_LEFT_FRONT_LEG).part(SkinPartTypes.HORSE_RIGHT_HIND_THIGH).part(SkinPartTypes.HORSE_LEFT_HIND_THIGH).part(SkinPartTypes.HORSE_RIGHT_HIND_LEG).part(SkinPartTypes.HORSE_LEFT_HIND_LEG).part(SkinPartTypes.HORSE_TAIL).build("horse");
    public static final SkinType BOAT = SkinTypes.item(19).part(SkinPartTypes.BOAT_BODY).part(SkinPartTypes.BOAT_LEFT_PADDLE).part(SkinPartTypes.BOAT_RIGHT_PADDLE).override(ItemOverrideType.BOAT).build("boat");
    public static final SkinType MINECART = SkinTypes.item(21).part(SkinPartTypes.MINECART_BODY).override(ItemOverrideType.MINECART).build("minecart");
    public static final SkinType ITEM_FISHING = SkinTypes.item(20).part(SkinPartTypes.ITEM_FISHING_ROD).part(SkinPartTypes.ITEM_FISHING_HOOK).override(ItemOverrideType.FISHING_ROD).build("fishing");
    public static final SkinType ITEM_BACKPACK = SkinTypes.item(24).part(SkinPartTypes.ITEM_BACKPACK).override(ItemOverrideType.BACKPACK).build("backpack");
    public static final SkinType ADVANCED = SkinTypes.normal(16).part(SkinPartTypes.ADVANCED).build("part");

    public static SkinType byName(String registryName) {
        if (registryName == null) {
            return UNKNOWN;
        }
        if (!((String)registryName).startsWith("armourers:")) {
            registryName = "armourers:" + (String)registryName;
        }
        if (((String)registryName).equals("armourers:skirt")) {
            return ARMOR_LEGS;
        }
        if (((String)registryName).equals("armourers:arrow")) {
            return ITEM_BOW;
        }
        return ALL_TYPES.getOrDefault(registryName, UNKNOWN);
    }

    public static ArrayList<SkinType> values() {
        return ALL_SORTED_TYPES;
    }

    private static Builder normal(int id) {
        return new Builder((builder, name) -> new SkinType((String)name, id, (List<? extends SkinPartType>)builder.partTypes));
    }

    private static Builder item(int id) {
        return new Builder((builder, name) -> new SkinType.Tool((String)name, id, (List<? extends SkinPartType>)builder.partTypes, builder.overrideType::isOverrideItem));
    }

    private static Builder armour(int id) {
        return new Builder((builder, name) -> new SkinType.Armor((String)name, id, builder.equipmentSlot, (List<? extends SkinPartType>)builder.partTypes));
    }

    private static class Builder {
        private ItemOverrideType overrideType;
        private OpenEquipmentSlot equipmentSlot;
        private final ArrayList<SkinPartType> partTypes = new ArrayList();
        private final BiFunction<Builder, String, SkinType> factory;

        public Builder(BiFunction<Builder, String, SkinType> factory) {
            this.factory = factory;
        }

        public Builder part(SkinPartType partType) {
            this.partTypes.add(partType);
            return this;
        }

        public Builder part(SkinType skinType) {
            this.partTypes.addAll(skinType.parts());
            return this;
        }

        public Builder override(ItemOverrideType overrideType) {
            this.overrideType = overrideType;
            return this;
        }

        public Builder equipmentSlot(OpenEquipmentSlot equipmentSlot) {
            this.equipmentSlot = equipmentSlot;
            return this;
        }

        public SkinType build(String name) {
            SkinType type = this.factory.apply(this, name);
            type.setRegistryName(OpenResourceLocation.create("armourers", name));
            if (type.parts().isEmpty()) {
                ModLog.warn("A mod tried to register a skin type no skin type parts.", new Object[0]);
                return type;
            }
            if (ALL_TYPES.containsKey(type.registryName().toString())) {
                ModLog.warn("A mod tried to register a skin type with a registry name that is in use.", new Object[0]);
                return type;
            }
            ALL_SORTED_TYPES.add(type);
            ALL_TYPES.put(type.registryName().toString(), type);
            ModLog.debug("Registering Skin '{}'", type.registryName());
            return type;
        }
    }
}

