/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.animation;

import java.io.IOException;
import java.util.List;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;

public abstract class SkinAnimationFunction {
    public static SkinAnimationFunction step() {
        return Step.INSTANCE;
    }

    public static SkinAnimationFunction linear() {
        return Linear.INSTANCE;
    }

    public static SkinAnimationFunction smooth() {
        return Smooth.INSTANCE;
    }

    public static SkinAnimationFunction bezier(float[] parameters) {
        return new Bezier(parameters);
    }

    public static SkinAnimationFunction bezier(List<Float> parameters) {
        float[] values = new float[12];
        for (int i = 0; i < values.length; ++i) {
            values[i] = parameters != null && i < parameters.size() ? parameters.get(i).floatValue() : 0.0f;
        }
        return new Bezier(values);
    }

    public static SkinAnimationFunction readFromStream(IInputStream stream) throws IOException {
        return switch (stream.readVarInt()) {
            case 3 -> SkinAnimationFunction.bezier(stream.readFloatArray(12));
            case 2 -> SkinAnimationFunction.smooth();
            case 1 -> SkinAnimationFunction.step();
            case 0 -> SkinAnimationFunction.linear();
            default -> SkinAnimationFunction.linear();
        };
    }

    public abstract float apply(float var1);

    public abstract void writeToStream(IOutputStream var1) throws IOException;

    public static class Step
    extends SkinAnimationFunction {
        private static final Step INSTANCE = new Step();

        @Override
        public float apply(float t) {
            return 0.0f;
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeVarInt(1);
        }

        public String toString() {
            return "step";
        }
    }

    public static class Linear
    extends SkinAnimationFunction {
        private static final Linear INSTANCE = new Linear();

        @Override
        public float apply(float t) {
            return t;
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeVarInt(0);
        }

        public String toString() {
            return "linear";
        }
    }

    public static class Smooth
    extends SkinAnimationFunction {
        private static final Smooth INSTANCE = new Smooth();

        @Override
        public float apply(float t) {
            if (t < 0.5f) {
                return this.applyEaseIn(t * 2.0f) / 2.0f;
            }
            return 1.0f - this.applyEaseIn((1.0f - t) * 2.0f) / 2.0f;
        }

        public float applyEaseIn(float t) {
            return 0.5f * (2.0f * (t + 1.0f) + (t + 2.0f - t) * 1.0f + (2.0f * t - 5.0f * (t + 1.0f) + 4.0f * (t + 2.0f) - (t + 3.0f)) * 1.0f + (3.0f * (t + 1.0f) - t - 3.0f * (t + 2.0f) + (t + 3.0f)) * 1.0f);
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeVarInt(2);
        }

        public String toString() {
            return "smooth";
        }
    }

    public static class Bezier
    extends SkinAnimationFunction {
        private final float[] parameters;

        public Bezier(float[] parameters) {
            this.parameters = parameters;
        }

        @Override
        public float apply(float t) {
            return t;
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeVarInt(3);
            stream.writeFloatArray(this.parameters);
        }

        public String toString() {
            return String.format("bezier(%s)", new Object[]{this.parameters});
        }
    }
}

