/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import net.minecraft.nbt.CompoundTag;

public class SkinDocumentListeners {

    public static class Updater
    implements SkinDocumentListener {
        private final UpdatableBlockEntity blockEntity;

        public Updater(UpdatableBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        @Override
        public void documentDidChangeType(SkinDocumentType type) {
            this.blockEntity.sendBlockUpdates();
            this.blockEntity.setChanged();
        }

        @Override
        public void documentDidChangeSettings(CompoundTag tag) {
            this.blockEntity.setChanged();
        }

        @Override
        public void documentDidChangeProperties(CompoundTag tag) {
            this.blockEntity.setChanged();
        }

        @Override
        public void documentDidInsertNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
            this.blockEntity.setChanged();
        }

        @Override
        public void documentDidUpdateNode(SkinDocumentNode node, CompoundTag tag) {
            this.blockEntity.setChanged();
        }

        @Override
        public void documentDidRemoveNode(SkinDocumentNode node) {
            this.blockEntity.setChanged();
        }

        @Override
        public void documentDidMoveNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
            this.blockEntity.setChanged();
        }
    }

    public static class Proxy
    implements SkinDocumentListener {
        private final ArrayList<SkinDocumentListener> listeners = new ArrayList();

        @Override
        public void documentDidSelectNode(SkinDocumentNode node) {
            this.listeners.forEach(it -> it.documentDidSelectNode(node));
        }

        @Override
        public void documentDidReload() {
            this.listeners.forEach(SkinDocumentListener::documentDidReload);
        }

        @Override
        public void documentDidChangeType(SkinDocumentType type) {
            this.listeners.forEach(it -> it.documentDidChangeType(type));
        }

        @Override
        public void documentDidChangeSettings(CompoundTag tag) {
            this.listeners.forEach(it -> it.documentDidChangeSettings(tag));
        }

        @Override
        public void documentDidChangeProperties(CompoundTag tag) {
            this.listeners.forEach(it -> it.documentDidChangeProperties(tag));
        }

        @Override
        public void documentDidInsertNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
            this.listeners.forEach(it -> it.documentDidInsertNode(node, target, index));
        }

        @Override
        public void documentDidUpdateNode(SkinDocumentNode node, CompoundTag tag) {
            this.listeners.forEach(it -> it.documentDidUpdateNode(node, tag));
        }

        @Override
        public void documentDidRemoveNode(SkinDocumentNode node) {
            this.listeners.forEach(it -> it.documentDidRemoveNode(node));
        }

        @Override
        public void documentDidMoveNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
            this.listeners.forEach(it -> it.documentDidMoveNode(node, target, index));
        }

        @Override
        public void documentWillBeginEditing() {
            this.listeners.forEach(SkinDocumentListener::documentWillBeginEditing);
        }

        @Override
        public void documentDidEndEditing() {
            this.listeners.forEach(SkinDocumentListener::documentDidEndEditing);
        }

        public void addListener(SkinDocumentListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(SkinDocumentListener listener) {
            this.listeners.remove(listener);
        }
    }
}

