/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.PackResource;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import org.jetbrains.annotations.Nullable;

public class PackResourceSet {
    private final Collection<PackResource> resources;

    public PackResourceSet(File file) throws IOException {
        this.resources = this.getResourcesFromFile(file);
    }

    @Nullable
    public PackResource firstResource() {
        Iterator<PackResource> iterator = this.resources.iterator();
        if (iterator.hasNext()) {
            PackResource resource = iterator.next();
            return resource;
        }
        return null;
    }

    @Nullable
    public PackResource findResource(String regex) {
        Pattern pattern = Pattern.compile(regex, 2);
        for (PackResource resource : this.resources) {
            if (!pattern.matcher(resource.name()).find()) continue;
            return resource;
        }
        return null;
    }

    @Nullable
    public PackResource getResource(String name) {
        for (PackResource resource : this.resources) {
            if (!resource.name().equalsIgnoreCase(name)) continue;
            return resource;
        }
        return null;
    }

    public Collection<PackResource> getResources() {
        return this.resources;
    }

    protected Collection<PackResource> getResourcesFromFile(File file) throws IOException {
        if (file.isDirectory()) {
            return this.getResourcesFromDirectory(file);
        }
        if (file.getName().toLowerCase().endsWith(".zip")) {
            return this.getResourcesFromZip(file);
        }
        return this.getResourcesFromSet(file);
    }

    protected Collection<PackResource> getResourcesFromZip(File zipFile) throws IOException {
        ZipEntry entry;
        ArrayList<PackResource> resources = new ArrayList<PackResource>();
        final ZipFile file = new ZipFile(zipFile);
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        while ((entry = zip.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            final ZipEntry fileEntry = entry;
            resources.add(new PackResource(this){

                @Override
                public String name() {
                    return fileName;
                }

                @Override
                public InputStream inputStream() throws IOException {
                    return file.getInputStream(fileEntry);
                }
            });
        }
        return resources;
    }

    protected Collection<PackResource> getResourcesFromDirectory(File rootPath) throws IOException {
        ArrayList<PackResource> resources = new ArrayList<PackResource>();
        for (final File entry : FileUtils.listFilesRecursive(rootPath)) {
            if (entry.isDirectory()) continue;
            final String fileName = FileUtils.getRelativePath(entry, rootPath, true).substring(1);
            resources.add(new PackResource(this){

                @Override
                public String name() {
                    return fileName;
                }

                @Override
                public InputStream inputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }

    protected Collection<PackResource> getResourcesFromSet(File ... entries) throws IOException {
        ArrayList<PackResource> resources = new ArrayList<PackResource>();
        for (final File entry : entries) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            resources.add(new PackResource(this){

                @Override
                public String name() {
                    return fileName;
                }

                @Override
                public InputStream inputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }
}

