/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOExecutor;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCondition;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkNode;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkWriter;
import moe.plushie.armourers_workshop.core.utils.Collections;

public class ChunkDataOutputStream
implements ChunkOutputStream {
    private final ByteBuf buffer = Unpooled.buffer((int)1024);
    private final DataOutputStream outputStream = new DataOutputStream((OutputStream)new ByteBufOutputStream(this.buffer));
    private final ChunkContext context;
    private ChunkNode headNode;
    private ChunkNode tailNode;

    public ChunkDataOutputStream(ChunkContext context) {
        this.context = context;
        this.tailNode = this.headNode = new ChunkNode(0);
    }

    public void writeChunk(IOConsumer<ChunkWriter> consumer) throws IOException {
        this.writeChunk(ChunkWriter::new, consumer);
    }

    public <C extends ChunkWriter> void writeChunk(Function<ChunkDataOutputStream, C> provider, IOConsumer<C> consumer) throws IOException {
        consumer.accept((ChunkWriter)provider.apply(this));
        this.appendVariable(null);
        this.writeInt(0);
    }

    public void writeVariable(ChunkVariable variable) throws IOException {
        this.appendVariable(variable);
    }

    public void transferTo(OutputStream finalStream) throws IOException {
        this.appendVariable(null);
        ChunkNode node = this.headNode;
        LinkedList<ChunkNode> pending = new LinkedList<ChunkNode>();
        while (node != null) {
            if (!node.freeze()) {
                pending.add(node);
            }
            node = node.next;
        }
        Iterator iterator = Collections.cycle(pending);
        while (iterator.hasNext()) {
            if (!((ChunkNode)iterator.next()).freeze()) continue;
            iterator.remove();
        }
        byte[] bytes = this.buffer.array();
        node = this.headNode;
        while (node != null) {
            node.write(bytes, finalStream);
            ChunkNode next = node.next;
            node.next = null;
            node = next;
        }
        this.headNode = null;
        this.tailNode = null;
    }

    protected void ifTask(ChunkCondition condition, IOExecutor executor) throws IOException {
        switch (condition.result()) {
            case PASS: {
                executor.run();
                break;
            }
            case PENDING: {
                ChunkNode start = this.appendVariable(null);
                executor.run();
                this.appendNode(new ChunkNode.If(this.buffer.writerIndex(), start, condition));
            }
        }
    }

    protected void sumTask(IntConsumer callback, IOExecutor executor) throws IOException {
        ChunkNode start = this.appendVariable(null);
        executor.run();
        this.appendNode(new ChunkNode.Sum(this.buffer.writerIndex(), start, callback));
    }

    protected void compressTask(ChunkFlags flags, IOExecutor executor) throws IOException {
        if (flags.isEmpty()) {
            executor.run();
            return;
        }
        ChunkNode start = this.appendVariable(null);
        executor.run();
        this.appendNode(new ChunkNode.Compressed(this.buffer.writerIndex(), start, flags, this));
    }

    @Override
    public DataOutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public ChunkContext context() {
        return this.context;
    }

    protected ByteBuf buffer() {
        return this.buffer;
    }

    protected ChunkNode appendVariable(ChunkVariable var) {
        ChunkNode node = ChunkNode.of(this.buffer.writerIndex(), var, this);
        return this.appendNode(node);
    }

    protected ChunkNode appendNode(ChunkNode node) {
        this.tailNode.next = node;
        this.tailNode = node;
        return node;
    }
}

