/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.ItemStackStorage;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static final int[] PALETTE_MINECRAFT = new int[]{0xFFFFFF, 0xFFFF55, 0xFF55FF, 0xFF5555, 0x55FFFF, 0x55FF55, 0x5555FF, 0x555555, 0xAAAAAA, 0xFFAA00, 0xAA00AA, 0xAA0000, 43690, 43520, 170, 0, 0xDDDDDD, 14384446, 11751612, 7047881, 11642407, 4304440, 13665433, 0x404040, 0x9AA1A1, 3042953, 8273333, 3029133, 5190175, 3491355, 9843760, 0x191616};
    public static final int[] PALETTE_SHADES = new int[]{460551, 986895, 0x171717, 0x1F1F1F, 0x272727, 0x2F2F2F, 0x373737, 0x3F3F3F, 0x474747, 0x4F4F4F, 0x575757, 0x5F5F5F, 0x676767, 0x6F6F6F, 0x777777, 0x7F7F7F, 0x878787, 0x8F8F8F, 0x979797, 0x9F9F9F, 0xA7A7A7, 0xAFAFAF, 0xB7B7B7, 0xBFBFBF, 0xC7C7C7, 0xCFCFCF, 0xD7D7D7, 0xDFDFDF, 0xE7E7E7, 0xEFEFEF, 0xF7F7F7, 0xFFFFFF};
    public static final int[] PALETTE_WARM32 = new int[]{855582, 3092804, 6449779, 9741738, 13885409, 2693152, 6899529, 10841702, 13342320, 15521975, 2623789, 6892376, 8405089, 10572138, 14783379, 1973560, 5326185, 8681611, 12495039, 2305359, 3820397, 6650266, 10073309, 4285579, 7317955, 12182245, 13888216, 664357, 2113593, 4088392, 7835507, 11846568};
    public static final int[] PALETTE_PASTEL_64_A = new int[]{10060406, 0xC4C484, 11262083, 10678973, 0xB88488, 13742466, 13953937, 0xCCFCC4, 9467545, 12879012, 15371385, 15918498, 10126520, 13730506, 15438248, 16768452, 7769497, 0x8484C4, 12876266, 15901399, 0x84B8B4, 8561361, 10981867, 16500981, 8164730, 8701092, 7985130, 0xA2AFF2, 10664068, 8573321, 9563092, 13231610};
    public static final int[] PALETTE_PASTEL_64_B = new int[]{12101508, 12176009, 9563025, 13237481, 9795206, 12883076, 15392378, 12841634, 12092591, 13730447, 15449489, 16251332, 0x797699, 11830468, 15366587, 15903138, 8689080, 10322641, 15372779, 16763092, 7771533, 8697028, 7963370, 13738738, 8697997, 8573380, 9551595, 13813498, 0x969976, 9749636, 7989928, 10677234};
    public static final int[] PALETTE_SOFTMILK32 = new int[]{14244762, 10372241, 0x633662, 9452898, 12407130, 14064206, 15978560, 16771212, 0xF2F2F0, 9756818, 2070915, 2253675, 12937334, 6043713, 9721928, 13729643, 15441791, 15843983, 12170691, 7763069, 5723247, 2302269, 4538772, 4348861, 0x4884D4, 4563422, 8181995, 14873190, 12833858, 0x82AA28, 5865246, 3629353};
    public static final int[] PALETTE_ENDESGA_32 = new int[]{12470831, 14120515, 15389866, 14984818, 12087120, 7552569, 4073265, 10626611, 14957380, 16217634, 16690740, 16705377, 6539085, 4098376, 2513986, 1653822, 1199753, 39387, 2943221, 0xFFFFFF, 12635100, 9149364, 5925256, 3818598, 2501444, 1578021, 0xFF0044, 6830188, 11882632, 16151930, 15251350, 12748137};

    public static int makeColorBighter(int rgb, int amount) {
        int r = ColorUtils.getRed(rgb) + amount;
        int g = ColorUtils.getGreen(rgb) + amount;
        int b = ColorUtils.getBlue(rgb) + amount;
        r = OpenMath.clamp(r, 0, 255);
        g = OpenMath.clamp(g, 0, 255);
        b = OpenMath.clamp(b, 0, 255);
        return ColorUtils.getRGB(r, g, b);
    }

    public static int makeColourDarker(int rgb, int amount) {
        int r = ColorUtils.getRed(rgb) - amount;
        int g = ColorUtils.getGreen(rgb) - amount;
        int b = ColorUtils.getBlue(rgb) - amount;
        r = OpenMath.clamp(r, 0, 255);
        g = OpenMath.clamp(g, 0, 255);
        b = OpenMath.clamp(b, 0, 255);
        return ColorUtils.getRGB(r, g, b);
    }

    public static int addColorNoise(int rgb, int amount, Random random) {
        int r = ColorUtils.getRed(rgb) - amount + random.nextInt(amount * 2);
        int g = ColorUtils.getGreen(rgb) - amount + random.nextInt(amount * 2);
        int b = ColorUtils.getBlue(rgb) - amount + random.nextInt(amount * 2);
        r = OpenMath.clamp(r, 0, 255);
        g = OpenMath.clamp(g, 0, 255);
        b = OpenMath.clamp(b, 0, 255);
        return ColorUtils.getRGB(r, g, b);
    }

    public static int addShadeNoise(int rgb, int amount, Random random) {
        int shadeAmount = random.nextInt(amount * 2);
        int r = ColorUtils.getRed(rgb) - amount + shadeAmount;
        int g = ColorUtils.getGreen(rgb) - amount + shadeAmount;
        int b = ColorUtils.getBlue(rgb) - amount + shadeAmount;
        r = OpenMath.clamp(r, 0, 255);
        g = OpenMath.clamp(g, 0, 255);
        b = OpenMath.clamp(b, 0, 255);
        return ColorUtils.getRGB(r, g, b);
    }

    public static int getAverageColor(Iterable<Integer> colors) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int count = 0;
        for (int rgb : colors) {
            red += ColorUtils.getRed(rgb);
            green += ColorUtils.getGreen(rgb);
            blue += ColorUtils.getBlue(rgb);
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return ColorUtils.getRGB(red / count, green / count, blue / count);
    }

    public static int getPaletteColor(int index) {
        return PALETTE_MINECRAFT[((index & Integer.MAX_VALUE) + 1) % PALETTE_MINECRAFT.length] | 0xFF000000;
    }

    public static int getRainbowRGB() {
        float f = (float)(System.currentTimeMillis() % 6375L) / 25.0f;
        return ColorUtils.HSBtoRGB(f / 255.0f, 1.0f, 1.0f);
    }

    public static int getPulse1Color(int color) {
        float f = (float)((double)System.currentTimeMillis() % 6375.0) / 25.0f;
        if ((f *= 2.0f) > 255.0f) {
            f = 255.0f - (f - 255.0f);
        }
        f = OpenMath.clamp(f, 0.0f, 255.0f);
        float[] hsb = ColorUtils.RGBtoHSB(ColorUtils.getRed(color), ColorUtils.getGreen(color), ColorUtils.getBlue(color), null);
        return ColorUtils.HSBtoRGB(hsb[0], hsb[1], f / 255.0f);
    }

    public static int getPulse2Color(int color) {
        float f = (float)((double)System.currentTimeMillis() % 3187.5) / 12.5f;
        if ((f *= 2.0f) > 255.0f) {
            f = 255.0f - (f - 255.0f);
        }
        f = OpenMath.clamp(f, 0.0f, 255.0f);
        float[] hsb = ColorUtils.RGBtoHSB(ColorUtils.getRed(color), ColorUtils.getGreen(color), ColorUtils.getBlue(color), null);
        return ColorUtils.HSBtoRGB(hsb[0], hsb[1], f / 255.0f);
    }

    public static int getDisplayRGB(SkinPaintColor paintColor) {
        SkinPaintType paintType = paintColor.paintType();
        if (paintType == SkinPaintTypes.RAINBOW) {
            return ColorUtils.getRainbowRGB();
        }
        if (paintType == SkinPaintTypes.PULSE_1) {
            return ColorUtils.getPulse1Color(paintColor.argb());
        }
        if (paintType == SkinPaintTypes.PULSE_2) {
            return ColorUtils.getPulse2Color(paintColor.argb());
        }
        return paintColor.argb();
    }

    public static int getDisplayRGB(ItemStack itemStack) {
        SkinPaintColor paintColor = (SkinPaintColor)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
        if (paintColor != null) {
            return ColorUtils.getDisplayRGB(paintColor) | 0xFF000000;
        }
        return -1;
    }

    @Nullable
    public static BlockPaintColor getBlockColor(ItemStack itemStack) {
        CompoundTag colorTag;
        ItemStackStorage storage = ItemStackStorage.of(itemStack);
        if (storage.blockPaintColor != null) {
            return storage.blockPaintColor.orElse(null);
        }
        BlockPaintColor color = null;
        CompoundTag tag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (tag != null && (colorTag = (CompoundTag)OptionalAPI.getOptionalCompound(tag, "Color").orElse(null)) != null && !colorTag.isEmpty()) {
            color = new BlockPaintColor(new TagSerializer(colorTag));
        }
        storage.blockPaintColor = Optional.ofNullable(color);
        return color;
    }

    public static ArrayList<Component> getColorTooltips(SkinPaintColor color, boolean useDisplayColor) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        int rgb = color.argb();
        if (useDisplayColor) {
            rgb = ColorUtils.getDisplayRGB(color);
        }
        SkinPaintType paintType = color.paintType();
        String hexColor = String.format("#%06x", rgb & 0xFFFFFF);
        MutableComponent paintName = TranslateUtils.Name.of(paintType);
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.colour", rgb & 0xFFFFFF));
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.hex", hexColor));
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.paintType", paintName));
        return tooltips;
    }

    public static int mix(int a, int b, float q) {
        return (int)((float)a * (1.0f - q) + (float)b * q);
    }

    public static int parseColor(String colorString) {
        try {
            int value = Integer.decode(colorString);
            if ((value & 0xFF000000) == 0) {
                value |= 0xFF000000;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static int getAlpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int getRGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static int getARGB(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int HSBtoRGB(float[] hsb) {
        return ColorUtils.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] RGBtoHSB(int rgb) {
        return ColorUtils.RGBtoHSB(ColorUtils.getRed(rgb), ColorUtils.getGreen(rgb), ColorUtils.getBlue(rgb), null);
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }
}

