/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenModelPart;

public class OpenModelPartBuilder {
    private static final Set<OpenDirection> ALL_VISIBLE = EnumSet.allOf(OpenDirection.class);
    protected int texU = 0;
    protected int texV = 0;
    protected final int texWidth;
    protected final int texHeight;
    protected boolean mirror = false;
    protected OpenModelPart.Pose offset = OpenModelPart.Pose.ZERO;
    protected final ArrayList<OpenModelPart.Cube> cubes = new ArrayList();

    protected OpenModelPartBuilder(int width, int texHeight) {
        this.texWidth = width;
        this.texHeight = texHeight;
    }

    public static OpenModelPartBuilder of(int width, int height) {
        return new OpenModelPartBuilder(width, height);
    }

    public static OpenModelPartBuilder player() {
        return OpenModelPartBuilder.of(64, 64);
    }

    public OpenModelPartBuilder uv(int u, int v) {
        this.texU = u;
        this.texV = v;
        return this;
    }

    public OpenModelPartBuilder offset(float x, float y, float z) {
        this.offset = OpenModelPart.Pose.offset(x, y, z);
        return this;
    }

    public OpenModelPartBuilder cube(float x, float y, float z, float width, float height, float depth) {
        return this.cube(x, y, z, width, height, depth, 0.0f);
    }

    public OpenModelPartBuilder cube(float x, float y, float z, float width, float height, float depth, float scale) {
        this.cubes.add(new OpenModelPart.Cube(this.texU, this.texV, x, y, z, width, height, depth, scale, scale, scale, this.mirror, this.texWidth, this.texHeight, ALL_VISIBLE));
        return this;
    }

    public OpenModelPartBuilder mirror() {
        this.mirror = true;
        return this;
    }

    public OpenModelPart build() {
        OpenModelPart modelPart = new OpenModelPart(this.cubes, new HashMap<String, OpenModelPart>());
        modelPart.setInitialPose(this.offset);
        modelPart.loadPose(this.offset);
        return modelPart;
    }
}

