/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import com.mojang.blaze3d.platform.NativeImage;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OpenNativeImage {
    private final NativeImage impl;

    private OpenNativeImage(NativeImage impl) {
        this.impl = impl;
    }

    public static OpenNativeImage of(NativeImage image) {
        if (image != null) {
            return new OpenNativeImage(image);
        }
        return null;
    }

    public static OpenNativeImage of(int textureId, int width, int height) {
        OpenNativeImage image = new OpenNativeImage(new NativeImage(width, height, true));
        image.impl.downloadTexture(textureId, false);
        return image;
    }

    public int getPixel(int x, int y) {
        int color = this.impl.getPixelRGBA(x, y);
        int red = color << 16 & 0xFF0000;
        int blue = color >> 16 & 0xFF;
        return color & 0xFF00FF00 | red | blue;
    }

    public void setPixel(int x, int y, int color) {
        int red = color >> 16 & 0xFF;
        int blue = color << 16 & 0xFF0000;
        this.impl.setPixelRGBA(x, y, color & 0xFF00FF00 | red | blue);
    }

    public void copyFrom(OpenNativeImage image) {
        this.impl.copyFrom(image.impl);
    }

    public OpenNativeImage clone() {
        NativeImage newValue = new NativeImage(this.impl.format(), this.impl.getWidth(), this.impl.getHeight(), true);
        return new OpenNativeImage(newValue);
    }

    public int width() {
        return this.impl.getWidth();
    }

    public int height() {
        return this.impl.getHeight();
    }
}

