/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import net.minecraft.resources.ResourceLocation;

public class OpenResourceLocation
implements IResourceLocation,
Comparable<OpenResourceLocation> {
    private final String namespace;
    private final String path;
    private ResourceLocation resourceLocation;

    private OpenResourceLocation(String namespace, String path) {
        this.namespace = namespace;
        this.path = path;
    }

    public static OpenResourceLocation create(ResourceLocation location) {
        OpenResourceLocation newValue = new OpenResourceLocation(location.getNamespace(), location.getPath());
        newValue.resourceLocation = location;
        return newValue;
    }

    public static OpenResourceLocation create(String namespace, String path) {
        return new OpenResourceLocation(namespace, path);
    }

    public static OpenResourceLocation parse(String id) {
        String path;
        int i = id.indexOf(58);
        String namespace = "minecraft";
        if (i >= 0) {
            path = id.substring(i + 1);
            if (i != 0) {
                namespace = id.substring(0, i);
            }
        } else {
            path = id;
        }
        return OpenResourceLocation.create(namespace, path);
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OpenResourceLocation)) {
            return false;
        }
        OpenResourceLocation that = (OpenResourceLocation)object;
        return this.namespace.equals(that.namespace) && this.path.equals(that.path);
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(OpenResourceLocation resourceLocation) {
        int i = this.path.compareTo(resourceLocation.path);
        if (i == 0) {
            i = this.namespace.compareTo(resourceLocation.namespace);
        }
        return i;
    }

    @Override
    public OpenResourceLocation withPath(String path) {
        return OpenResourceLocation.create(this.namespace, path);
    }

    @Override
    public OpenResourceLocation withNamespace(String namespace) {
        return OpenResourceLocation.create(namespace, this.path);
    }

    @Override
    public ResourceLocation toLocation() {
        if (this.resourceLocation == null) {
            this.resourceLocation = IResourceLocation.super.toLocation();
        }
        return this.resourceLocation;
    }
}

