/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.registry.IItemBuilder;
import moe.plushie.armourers_workshop.builder.client.render.SkinCubeItemRenderer;
import moe.plushie.armourers_workshop.builder.item.BlendingToolItem;
import moe.plushie.armourers_workshop.builder.item.BlockMarkerItem;
import moe.plushie.armourers_workshop.builder.item.BurnToolItem;
import moe.plushie.armourers_workshop.builder.item.ColorNoiseToolItem;
import moe.plushie.armourers_workshop.builder.item.ColorPickerItem;
import moe.plushie.armourers_workshop.builder.item.DodgeToolItem;
import moe.plushie.armourers_workshop.builder.item.HueToolItem;
import moe.plushie.armourers_workshop.builder.item.PaintRollerItem;
import moe.plushie.armourers_workshop.builder.item.PaintbrushItem;
import moe.plushie.armourers_workshop.builder.item.ShadeNoiseToolItem;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.builder.item.SoapItem;
import moe.plushie.armourers_workshop.core.client.render.MannequinItemRenderer;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.item.ArmourersHammerItem;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.item.GiftSackItem;
import moe.plushie.armourers_workshop.core.item.LinkingToolItem;
import moe.plushie.armourers_workshop.core.item.MannequinItem;
import moe.plushie.armourers_workshop.core.item.MannequinToolItem;
import moe.plushie.armourers_workshop.core.item.SkinItem;
import moe.plushie.armourers_workshop.core.item.SkinUnlockItem;
import moe.plushie.armourers_workshop.core.item.WandOfStyleItem;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.ModItemGroups;
import moe.plushie.armourers_workshop.init.platform.BuilderManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;

public class ModItems {
    private static final ItemBuilder MAIN = new ItemBuilder(ModItemGroups.MAIN_GROUP);
    private static final ItemBuilder BUILDING = new ItemBuilder(ModItemGroups.BUILDING_GROUP);
    private static final ItemBuilder NONE = new ItemBuilder(null);
    public static final IRegistryHolder<Item> SKIN = (IRegistryHolder)NONE.skin(ModBlocks.SKINNABLE).bind(() -> SkinItemRenderer::getInstance).build("skin");
    public static final IRegistryHolder<Item> MANNEQUIN = (IRegistryHolder)MAIN.normal(MannequinItem::new).rarity(Rarity.RARE).bind(() -> MannequinItemRenderer::getInstance).build("mannequin");
    public static final IRegistryHolder<Item> SKIN_LIBRARY = (IRegistryHolder)MAIN.block(ModBlocks.SKIN_LIBRARY).build("skin-library");
    public static final IRegistryHolder<Item> SKIN_LIBRARY_CREATIVE = (IRegistryHolder)MAIN.block(ModBlocks.SKIN_LIBRARY_CREATIVE).rarity(Rarity.EPIC).build("skin-library-creative");
    public static final IRegistryHolder<Item> SKIN_LIBRARY_GLOBAL = (IRegistryHolder)MAIN.block(ModBlocks.SKIN_LIBRARY_GLOBAL).build("skin-library-global");
    public static final IRegistryHolder<Item> SKINNING_TABLE = (IRegistryHolder)MAIN.block(ModBlocks.SKINNING_TABLE).build("skinning-table");
    public static final IRegistryHolder<Item> DYE_TABLE = (IRegistryHolder)MAIN.block(ModBlocks.DYE_TABLE).build("dye-table");
    public static final IRegistryHolder<Item> OUTFIT_MAKER = (IRegistryHolder)MAIN.block(ModBlocks.OUTFIT_MAKER).build("outfit-maker");
    public static final IRegistryHolder<Item> HOLOGRAM_PROJECTOR = (IRegistryHolder)MAIN.block(ModBlocks.HOLOGRAM_PROJECTOR).build("hologram-projector");
    public static final IRegistryHolder<Item> BOTTLE = (IRegistryHolder)MAIN.normal(BottleItem::new).stacksTo(64).build("dye-bottle");
    public static final IRegistryHolder<Item> MANNEQUIN_TOOL = (IRegistryHolder)MAIN.normal(MannequinToolItem::new).build("mannequin-tool");
    public static final IRegistryHolder<Item> ARMOURERS_HAMMER = (IRegistryHolder)MAIN.normal(ArmourersHammerItem::new).build("armourers-hammer");
    public static final IRegistryHolder<Item> WAND_OF_STYLE = (IRegistryHolder)MAIN.normal(WandOfStyleItem::new).build("wand-of-style");
    public static final IRegistryHolder<Item> SKIN_UNLOCK_HEAD = (IRegistryHolder)MAIN.unlock(SkinSlotType.HEAD).build("skin-unlock-head");
    public static final IRegistryHolder<Item> SKIN_UNLOCK_CHEST = (IRegistryHolder)MAIN.unlock(SkinSlotType.CHEST).build("skin-unlock-chest");
    public static final IRegistryHolder<Item> SKIN_UNLOCK_FEET = (IRegistryHolder)MAIN.unlock(SkinSlotType.FEET).build("skin-unlock-feet");
    public static final IRegistryHolder<Item> SKIN_UNLOCK_LEGS = (IRegistryHolder)MAIN.unlock(SkinSlotType.LEGS).build("skin-unlock-legs");
    public static final IRegistryHolder<Item> SKIN_UNLOCK_WINGS = (IRegistryHolder)MAIN.unlock(SkinSlotType.WINGS).build("skin-unlock-wings");
    public static final IRegistryHolder<Item> SKIN_UNLOCK_OUTFIT = (IRegistryHolder)MAIN.unlock(SkinSlotType.OUTFIT).build("skin-unlock-outfit");
    public static final IRegistryHolder<Item> LINKING_TOOL = (IRegistryHolder)MAIN.normal(LinkingToolItem::new).build("linking-tool");
    public static final IRegistryHolder<Item> SKIN_TEMPLATE = (IRegistryHolder)MAIN.normal(FlavouredItem::new).stacksTo(64).build("skin-template");
    public static final IRegistryHolder<Item> SOAP = (IRegistryHolder)MAIN.normal(SoapItem::new).stacksTo(64).build("soap");
    public static final IRegistryHolder<Item> GIFT_SACK = (IRegistryHolder)MAIN.normal(GiftSackItem::new).stacksTo(64).build("gift-sack");
    public static final IRegistryHolder<Item> ARMOURER = (IRegistryHolder)BUILDING.block(ModBlocks.ARMOURER).rarity(Rarity.EPIC).build("armourer");
    public static final IRegistryHolder<Item> COLOR_MIXER = (IRegistryHolder)BUILDING.block(ModBlocks.COLOR_MIXER).build("colour-mixer");
    public static final IRegistryHolder<Item> ADVANCED_SKIN_BUILDER = (IRegistryHolder)BUILDING.block(ModBlocks.ADVANCED_SKIN_BUILDER).build("advanced-skin-builder");
    public static final IRegistryHolder<Item> SKIN_CUBE = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE).build("skin-cube");
    public static final IRegistryHolder<Item> SKIN_CUBE_GLOWING = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE_GLOWING).build("skin-cube-glowing");
    public static final IRegistryHolder<Item> SKIN_CUBE_GLASS = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE_GLASS).build("skin-cube-glass");
    public static final IRegistryHolder<Item> SKIN_CUBE_GLASS_GLOWING = (IRegistryHolder)BUILDING.cube(ModBlocks.SKIN_CUBE_GLASS_GLOWING).build("skin-cube-glass-glowing");
    public static final IRegistryHolder<Item> PAINT_BRUSH = (IRegistryHolder)BUILDING.normal(PaintbrushItem::new).build("paintbrush");
    public static final IRegistryHolder<Item> PAINT_ROLLER = (IRegistryHolder)BUILDING.normal(PaintRollerItem::new).build("paint-roller");
    public static final IRegistryHolder<Item> BURN_TOOL = (IRegistryHolder)BUILDING.normal(BurnToolItem::new).build("burn-tool");
    public static final IRegistryHolder<Item> DODGE_TOOL = (IRegistryHolder)BUILDING.normal(DodgeToolItem::new).build("dodge-tool");
    public static final IRegistryHolder<Item> SHADE_NOISE_TOOL = (IRegistryHolder)BUILDING.normal(ShadeNoiseToolItem::new).build("shade-noise-tool");
    public static final IRegistryHolder<Item> COLOR_NOISE_TOOL = (IRegistryHolder)BUILDING.normal(ColorNoiseToolItem::new).build("colour-noise-tool");
    public static final IRegistryHolder<Item> BLENDING_TOOL = (IRegistryHolder)BUILDING.normal(BlendingToolItem::new).build("blending-tool");
    public static final IRegistryHolder<Item> HUE_TOOL = (IRegistryHolder)BUILDING.normal(HueToolItem::new).build("hue-tool");
    public static final IRegistryHolder<Item> COLOR_PICKER = (IRegistryHolder)BUILDING.normal(ColorPickerItem::new).build("colour-picker");
    public static final IRegistryHolder<Item> BLOCK_MARKER = (IRegistryHolder)BUILDING.normal(BlockMarkerItem::new).build("block-marker");

    public static void init() {
    }

    private static class ItemBuilder {
        IRegistryHolder<IItemGroup> group;

        ItemBuilder(IRegistryHolder<IItemGroup> group) {
            this.group = group;
        }

        IItemBuilder<Item> normal(Function<Item.Properties, Item> factory) {
            return this._create(factory).stacksTo(1).group(this.group);
        }

        IItemBuilder<Item> block(IRegistryHolder<Block> block) {
            return this._create(BlockItem::new, block).stacksTo(64).rarity(Rarity.RARE);
        }

        IItemBuilder<Item> cube(IRegistryHolder<Block> block) {
            return this._create(SkinCubeItem::new, block).stacksTo(64).bind(() -> SkinCubeItemRenderer::getInstance);
        }

        IItemBuilder<Item> skin(IRegistryHolder<Block> block) {
            return this._create(SkinItem::new, block).stacksTo(1);
        }

        IItemBuilder<Item> unlock(SkinSlotType slotType) {
            return this._create(SkinUnlockItem::new, () -> slotType).stacksTo(16).rarity(Rarity.UNCOMMON);
        }

        private IItemBuilder<Item> _create(Function<Item.Properties, Item> factory) {
            return (IItemBuilder)Objects.unsafeCast(BuilderManager.getInstance().createItemBuilder(factory));
        }

        private <T> IItemBuilder<Item> _create(BiFunction<T, Item.Properties, Item> factory, Supplier<T> supplier) {
            return this._create(properties -> (Item)factory.apply(supplier.get(), (Item.Properties)properties)).group(this.group);
        }
    }
}

