/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import java.util.function.Function;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Minecraft.ItemModelProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModel;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModels;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinLuminanceManager;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
public class ClientDynamicLightHandler {
    private static Entity TICKING_ENTITY;

    public static void init() {
        ModConfig.Client.enableDynamicLightHandler = true;
    }

    public static void startTick(Entity entity) {
        TICKING_ENTITY = entity;
    }

    public static void endTick(Entity entity) {
        TICKING_ENTITY = null;
    }

    public static void apply(ItemStack itemStack, boolean submergedInWater, CallbackInfoReturnable<Integer> cir) {
        if (!ModConfig.enableDynamicLightHandler()) {
            return;
        }
        EmbeddedItemModel itemModel = ClientDynamicLightHandler.getItemModel(itemStack);
        if (itemModel == null) {
            return;
        }
        SkinDescriptor descriptor = itemModel.sourceSkin();
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
        if (bakedSkin != null) {
            cir.setReturnValue((Object)bakedSkin.renderInfo().luminance());
        }
    }

    public static <T extends Entity, A> A apply(A handler, T entity, Function<SkinLuminanceManager<? super T>, A> builder) {
        SkinLuminanceManager manger;
        if (!ModConfig.enableDynamicLightHandler()) {
            return handler;
        }
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && (manger = renderData.luminanceManager()).isEnabled()) {
            return DataContainer.of(manger, builder);
        }
        return handler;
    }

    public static <T extends BlockEntity, A> A apply(A handler, T entity, Function<SkinLuminanceManager<? super T>, A> builder) {
        SkinLuminanceManager manager;
        if (!ModConfig.enableDynamicLightHandler()) {
            return handler;
        }
        BlockEntityRenderData renderData = BlockEntityRenderData.of(entity);
        if (renderData != null && (manager = renderData.luminanceManager()).isEnabled()) {
            return DataContainer.of(manager, builder);
        }
        return handler;
    }

    private static EmbeddedItemModel getItemModel(ItemStack itemStack) {
        Entity entity = TICKING_ENTITY;
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return ClientDynamicLightHandler.getItemModel(itemStack, PropertyProvider.getLevel((Entity)entity2), entity2);
        }
        return ClientDynamicLightHandler.getItemModel(itemStack, null, null);
    }

    private static EmbeddedItemModel getItemModel(ItemStack itemStack, @Nullable Level level, @Nullable LivingEntity entity) {
        BakedModel model = ItemModelProvider.getItemModel(EnvironmentManager.getClient(), itemStack, level, entity, 0);
        EmbeddedItemModels itemModels = EmbeddedItemModels.of(itemStack);
        return itemModels.get(model);
    }
}

