/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class UpdateContextPacket
extends CustomPacket {
    private UUID owner = null;
    private ByteBuf buffer = null;
    private final int flags;

    public UpdateContextPacket(int flags, UUID player) {
        this.flags = flags;
        this.owner = player;
    }

    public UpdateContextPacket(IFriendlyByteBuf buffer) {
        this.flags = buffer.readByte();
        this.buffer = buffer.asByteBuf();
        this.buffer.retain();
    }

    public static UpdateContextPacket sync(Player player) {
        int flags = 1;
        if (EnvironmentManager.isDedicatedServer()) {
            flags |= 2;
            flags |= 4;
        }
        return new UpdateContextPacket(flags, player.getUUID());
    }

    public static UpdateContextPacket config() {
        return new UpdateContextPacket(2, null);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeByte(this.flags);
        if ((this.flags & 1) != 0) {
            buffer.writeUUID(ModContext.t2(this.owner));
            buffer.writeUUID(ModContext.t3(this.owner));
            buffer.writeLong(ModContext.time());
            buffer.writeUtf("3.17");
        }
        if ((this.flags & 2) != 0) {
            buffer.writeNbt(this.getConfig());
        }
        if ((this.flags & 4) != 0) {
            buffer.writeNbt(this.dataPack());
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        if (this.buffer == null) {
            return;
        }
        IFriendlyByteBuf reader = IFriendlyByteBuf.wrap(this.buffer);
        if ((this.flags & 1) != 0) {
            ModContext.init(reader.readUUID(), reader.readUUID());
            TickUtils.setTime(reader.readLong());
            this.checkNetworkVersion(reader.readUtf());
        }
        if ((this.flags & 2) != 0) {
            this.setConfig(reader.readNbt());
        }
        if ((this.flags & 4) != 0) {
            this.setDataPack(reader.readNbt());
        }
        this.buffer.release();
        this.buffer = null;
    }

    private void setConfig(CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            return;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        SkinProperties properties = new SkinProperties(tag);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            fields.put(entry.getKey(), entry.getValue());
        }
        ModConfigSpec.COMMON.apply(fields);
    }

    private CompoundTag getConfig() {
        SkinProperties properties = new SkinProperties();
        ModConfigSpec.COMMON.snapshot().forEach(properties::put);
        return properties.serializeNBT();
    }

    private void setDataPack(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        DataPack pack = new DataPack(new TagSerializer(tag));
    }

    private CompoundTag dataPack() {
        DataPack dataPack = new DataPack();
        TagSerializer serializer = new TagSerializer();
        dataPack.serialize(serializer);
        return serializer.tag();
    }

    private void checkNetworkVersion(String version) {
        if (!version.equals("3.17")) {
            ModLog.warn("network protocol conflict, server: {}, client: {}", version, "3.17");
        }
    }

    private static class DataPack
    implements IDataSerializable.Immutable {
        public DataPack() {
        }

        public DataPack(IDataSerializer serializer) {
            LinkedHashMap profiles = new LinkedHashMap();
            List<CompoundTag> profileTags = serializer.read(CodingKeys.PROFILES);
            profileTags.forEach(tag -> {
                TagSerializer serializer1 = new TagSerializer((CompoundTag)tag);
                EntityProfile profile = new EntityProfile(serializer1);
                List<String> entities = serializer1.read(CodingKeys.ENTITIES);
                entities.forEach(it -> profiles.put(IEntityTypeProvider.of(it), profile));
            });
            ModEntityProfiles.setCustomProfiles(profiles);
        }

        @Override
        public void serialize(IDataSerializer serializer) {
            ArrayList profileTags = new ArrayList();
            LinkedHashMap<EntityProfile, ArrayList> profiles = new LinkedHashMap<EntityProfile, ArrayList>();
            ModEntityProfiles.getCustomProfiles().forEach((entityType, profile) -> profiles.computeIfAbsent((EntityProfile)profile, e -> new ArrayList()).add(entityType.registryName()));
            profiles.forEach((profile, entities) -> {
                TagSerializer serializer1 = new TagSerializer();
                profile.serialize(serializer1);
                serializer1.write(CodingKeys.ENTITIES, entities);
                profileTags.add(serializer1.tag());
            });
            serializer.write(CodingKeys.PROFILES, profileTags);
        }
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<List<String>> ENTITIES = IDataSerializerKey.create("Entities", IDataCodec.STRING.listOf(), Collections.emptyList());
        public static final IDataSerializerKey<List<CompoundTag>> PROFILES = IDataSerializerKey.create("Profiles", IDataCodec.COMPOUND_TAG.listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }
}

