/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.registry.IBlockBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryBinder;
import moe.plushie.armourers_workshop.compatibility.api.AbstractBlockMaterial;
import moe.plushie.armourers_workshop.compatibility.api.AbstractBlockMaterialColor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.state.BlockBehaviour.Constructor;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBuilderImpl<T extends Block>
implements IBlockBuilder<T> {
    private BlockBehaviour.Properties properties;
    private IRegistryBinder<T> binder;
    private final Function<BlockBehaviour.Properties, T> supplier;

    public BlockBuilderImpl(Function<BlockBehaviour.Properties, T> supplier, AbstractBlockMaterial material, AbstractBlockMaterialColor materialColor) {
        this.properties = Constructor.Properties.of(BlockBehaviour.Properties.class, material, materialColor);
        this.supplier = supplier;
    }

    @Override
    public IBlockBuilder<T> noCollission() {
        this.properties = this.properties.noCollission();
        return this;
    }

    @Override
    public IBlockBuilder<T> noOcclusion() {
        this.properties = this.properties.noOcclusion();
        return this;
    }

    @Override
    public IBlockBuilder<T> friction(float f) {
        this.properties = this.properties.friction(f);
        return this;
    }

    @Override
    public IBlockBuilder<T> speedFactor(float f) {
        this.properties = this.properties.speedFactor(f);
        return this;
    }

    @Override
    public IBlockBuilder<T> jumpFactor(float f) {
        this.properties = this.properties.jumpFactor(f);
        return this;
    }

    @Override
    public IBlockBuilder<T> sound(SoundType soundType) {
        this.properties = this.properties.sound(soundType);
        return this;
    }

    @Override
    public IBlockBuilder<T> lightLevel(ToIntFunction<BlockState> toIntFunction) {
        this.properties = this.properties.lightLevel(toIntFunction);
        return this;
    }

    @Override
    public IBlockBuilder<T> strength(float f, float g) {
        this.properties = this.properties.strength(f, g);
        return this;
    }

    @Override
    public IBlockBuilder<T> randomTicks() {
        this.properties = this.properties.randomTicks();
        return this;
    }

    @Override
    public IBlockBuilder<T> dynamicShape() {
        this.properties = this.properties.dynamicShape();
        return this;
    }

    @Override
    public IBlockBuilder<T> noDrops() {
        this.properties = this.properties.noLootTable();
        return this;
    }

    @Override
    public IBlockBuilder<T> air() {
        this.properties = this.properties.air();
        return this;
    }

    @Override
    public IBlockBuilder<T> forceSolid() {
        this.properties = this.properties.forceSolidOn();
        return this;
    }

    @Override
    public IBlockBuilder<T> isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> stateArgumentPredicate) {
        this.properties = this.properties.isValidSpawn(stateArgumentPredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> isRedstoneConductor(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.isRedstoneConductor(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> isSuffocating(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.isSuffocating(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> isViewBlocking(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.isViewBlocking(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> hasPostProcess(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.hasPostProcess(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> emissiveRendering(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.emissiveRendering(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> requiresCorrectToolForDrops() {
        this.properties = this.properties.requiresCorrectToolForDrops();
        return this;
    }

    @Override
    public IBlockBuilder<T> bind(Supplier<Supplier<IRenderType>> provider) {
        this.binder = () -> arg_0 -> BlockBuilderImpl.lambda$bind$0((Supplier)provider, arg_0);
        return this;
    }

    @Override
    public IRegistryHolder<T> build(String name) {
        IRegistryHolder<Block> object = AbstractForgeRegistries.BLOCKS.register(name, () -> (Block)this.supplier.apply(this.properties));
        EnvironmentExecutor.didInit(EnvironmentType.CLIENT, IRegistryBinder.perform(this.binder, object));
        return object;
    }

    private static /* synthetic */ void lambda$bind$0(Supplier provider, IRegistryHolder block) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)((RenderType)((IRenderType)((Supplier)provider.get()).get()).get()));
    }
}

