/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.item;

import com.metacontent.cobblenav.item.PokenavModelType;
import com.metacontent.cobblenav.networking.packet.client.OpenPokenavPacket;
import com.metacontent.cobblenav.os.PokenavOS;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J5\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/metacontent/cobblenav/item/Pokenav;", "Lnet/minecraft/world/item/Item;", "Lcom/metacontent/cobblenav/item/PokenavModelType;", "model", "<init>", "(Lcom/metacontent/cobblenav/item/PokenavModelType;)V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "interactionHand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "itemStack", "", "getDescriptionId", "(Lnet/minecraft/world/item/ItemStack;)Ljava/lang/String;", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipContext", "", "Lnet/minecraft/network/chat/Component;", "list", "Lnet/minecraft/world/item/TooltipFlag;", "tooltipFlag", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lcom/metacontent/cobblenav/item/PokenavModelType;", "Companion", "cobblenav-common"})
public final class Pokenav
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PokenavModelType model;
    public static final int MAX_STACK = 1;
    @NotNull
    public static final String BASE_REGISTRY_KEY = "pokenav_item_";
    @NotNull
    public static final String TRANSLATION_KEY = "item.cobblenav.pokenav_item";
    @NotNull
    public static final String BASE_TOOLTIP_TRANSLATION_KEY = "item.cobblenav.pokenav_item.";

    public Pokenav(@NotNull PokenavModelType model) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        super(new Item.Properties().stacksTo(1));
        this.model = model;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (!level.isClientSide()) {
            ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
            if (serverPlayer != null) {
                ServerPlayer it = serverPlayer;
                boolean bl = false;
                new OpenPokenavPacket(new PokenavOS("Lite", true, false, false, false, 28, null)).sendToPlayer(it);
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(interactionHand), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    @NotNull
    public String getDescriptionId(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return TRANSLATION_KEY;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)tooltipContext, (String)"tooltipContext");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        MutableComponent mutableComponent = Component.translatable((String)(BASE_TOOLTIP_TRANSLATION_KEY + this.model.getModelName())).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/metacontent/cobblenav/item/Pokenav$Companion;", "", "<init>", "()V", "", "MAX_STACK", "I", "", "BASE_REGISTRY_KEY", "Ljava/lang/String;", "TRANSLATION_KEY", "BASE_TOOLTIP_TRANSLATION_KEY", "cobblenav-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

