/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.mixin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CurioAttributeModifiers;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.network.server.SPacketBreak;

public class CuriosImplMixinHooks {
    private static final Map<Item, ICurioItem> REGISTRY = new ConcurrentHashMap<Item, ICurioItem>();
    private static final Map<String, UUID> UUIDS = new HashMap<String, UUID>();
    private static final Map<ResourceLocation, Predicate<SlotResult>> SLOT_RESULT_PREDICATES = new HashMap<ResourceLocation, Predicate<SlotResult>>();

    public static void registerCurio(Item item, ICurioItem icurio) {
        REGISTRY.put(item, icurio);
    }

    public static Optional<ICurioItem> getCurioFromRegistry(Item item) {
        return Optional.ofNullable(REGISTRY.get(item));
    }

    public static Map<String, ISlotType> getSlots(boolean isClient) {
        CuriosSlotManager slotManager = isClient ? CuriosSlotManager.CLIENT : CuriosSlotManager.SERVER;
        return slotManager.getSlots();
    }

    public static Map<String, ISlotType> getEntitySlots(EntityType<?> type, boolean isClient) {
        CuriosEntityManager entityManager = isClient ? CuriosEntityManager.CLIENT : CuriosEntityManager.SERVER;
        return entityManager.getEntitySlots(type);
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, boolean isClient) {
        return CuriosImplMixinHooks.filteredSlots(slotType -> {
            SlotContext slotContext = new SlotContext(slotType.getIdentifier(), null, 0, false, true);
            SlotResult slotResult = new SlotResult(slotContext, stack);
            return CuriosApi.testCurioPredicates(slotType.getValidators(), slotResult);
        }, CuriosApi.getSlots(isClient));
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, LivingEntity livingEntity) {
        return CuriosImplMixinHooks.filteredSlots(slotType -> {
            SlotContext slotContext = new SlotContext(slotType.getIdentifier(), livingEntity, 0, false, true);
            SlotResult slotResult = new SlotResult(slotContext, stack);
            return CuriosApi.testCurioPredicates(slotType.getValidators(), slotResult);
        }, CuriosApi.getEntitySlots(livingEntity));
    }

    private static Map<String, ISlotType> filteredSlots(Predicate<ISlotType> filter, Map<String, ISlotType> map) {
        HashMap<String, ISlotType> result = new HashMap<String, ISlotType>();
        for (Map.Entry<String, ISlotType> entry : map.entrySet()) {
            ISlotType slotType = entry.getValue();
            if (!filter.test(slotType)) continue;
            result.put(entry.getKey(), slotType);
        }
        return result;
    }

    public static Optional<ICurio> getCurio(ItemStack stack) {
        return Optional.ofNullable((ICurio)stack.getCapability(CuriosCapability.ITEM));
    }

    public static Optional<ICuriosItemHandler> getCuriosInventory(LivingEntity livingEntity) {
        if (livingEntity != null) {
            return Optional.ofNullable((ICuriosItemHandler)livingEntity.getCapability(CuriosCapability.INVENTORY));
        }
        return Optional.empty();
    }

    public static boolean isStackValid(SlotContext slotContext, ItemStack stack) {
        String id = slotContext.identifier();
        LivingEntity entity = slotContext.entity();
        Map<String, ISlotType> map = entity != null ? CuriosImplMixinHooks.getItemStackSlots(stack, entity) : CuriosImplMixinHooks.getItemStackSlots(stack, FMLLoader.getDist() == Dist.CLIENT);
        Set<String> slots = map.keySet();
        if (!slots.isEmpty()) {
            return id.equals("curio") || slots.contains(id) || slots.contains("curio");
        }
        if (id.equals("curio")) {
            if (stack.getTags().anyMatch(tagKey -> tagKey.location().getNamespace().equals("curios"))) {
                return true;
            }
            Map<String, ISlotType> allSlots = CuriosApi.getSlots(false);
            SlotResult slotResult = new SlotResult(slotContext, stack);
            for (Map.Entry<String, ISlotType> entry : allSlots.entrySet()) {
                ISlotType slotType = entry.getValue();
                for (ResourceLocation validator : slotType.getValidators()) {
                    if (!CuriosApi.getCurioPredicate(validator).map(val -> val.test(slotResult)).orElse(false).booleanValue()) continue;
                    return true;
                }
            }
            return CuriosApi.getCurio(stack).isPresent();
        }
        return false;
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        CurioAttributeModifiers attributemodifiers = (CurioAttributeModifiers)stack.getOrDefault(CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS, (Object)CurioAttributeModifiers.EMPTY);
        if (!attributemodifiers.modifiers().isEmpty()) {
            for (CurioAttributeModifiers.Entry modifier : attributemodifiers.modifiers()) {
                if (!modifier.slot().equals(slotContext.identifier())) continue;
                ResourceLocation rl = modifier.attribute();
                AttributeModifier attributeModifier = modifier.modifier();
                if (rl == null) continue;
                AttributeModifier.Operation operation = attributeModifier.operation();
                double amount = attributeModifier.amount();
                if (rl.getNamespace().equals("curios")) {
                    LivingEntity livingEntity;
                    boolean clientSide;
                    String identifier1 = rl.getPath();
                    if (!CuriosApi.getSlot(identifier1, clientSide = (livingEntity = slotContext.entity()) == null || livingEntity.level().isClientSide()).isPresent()) continue;
                    CuriosApi.addSlotModifier((Multimap<Holder<Attribute>, AttributeModifier>)multimap, identifier1, id, amount, operation);
                    continue;
                }
                Holder attribute = BuiltInRegistries.ATTRIBUTE.getHolder(rl).orElse(null);
                if (attribute == null) continue;
                multimap.put((Object)attribute, (Object)new AttributeModifier(id, amount, operation));
            }
        } else {
            multimap = CuriosImplMixinHooks.getCurio(stack).map(curio -> curio.getAttributeModifiers(slotContext, id)).orElse((Multimap)multimap);
        }
        CurioAttributeModifierEvent evt = new CurioAttributeModifierEvent(stack, slotContext, id, (Multimap<Holder<Attribute>, AttributeModifier>)multimap);
        NeoForge.EVENT_BUS.post((Event)evt);
        return LinkedHashMultimap.create(evt.getModifiers());
    }

    public static void addSlotModifier(Multimap<Holder<Attribute>, AttributeModifier> map, String identifier, ResourceLocation id, double amount, AttributeModifier.Operation operation) {
        map.put(SlotAttribute.getOrCreate(identifier), (Object)new AttributeModifier(id, amount, operation));
    }

    public static void addSlotModifier(ItemStack stack, String identifier, ResourceLocation id, double amount, AttributeModifier.Operation operation, String slot) {
        CuriosImplMixinHooks.addModifier(stack, SlotAttribute.getOrCreate(identifier), id, amount, operation, slot);
    }

    public static void addModifier(ItemStack stack, Holder<Attribute> attribute, ResourceLocation id, double amount, AttributeModifier.Operation operation, String slot) {
        ResourceLocation rl;
        Object object = attribute.value();
        if (object instanceof SlotAttribute) {
            SlotAttribute wrapper = (SlotAttribute)((Object)object);
            rl = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)wrapper.getIdentifier());
        } else {
            rl = BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)attribute.value()));
        }
        CurioAttributeModifiers.Entry entry = new CurioAttributeModifiers.Entry(rl, new AttributeModifier(id, amount, operation), slot);
        CurioAttributeModifiers curioAttributeModifiers = (CurioAttributeModifiers)stack.getOrDefault(CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS, (Object)CurioAttributeModifiers.EMPTY);
        ArrayList<CurioAttributeModifiers.Entry> list = new ArrayList<CurioAttributeModifiers.Entry>(curioAttributeModifiers.modifiers());
        list.add(entry);
        stack.set(CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS, (Object)new CurioAttributeModifiers(list, curioAttributeModifiers.showInTooltip()));
    }

    public static void broadcastCurioBreakEvent(SlotContext slotContext) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity != null) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)livingEntity, (CustomPacketPayload)new SPacketBreak(livingEntity.getId(), slotContext.identifier(), slotContext.index()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static ResourceLocation getSlotId(SlotContext slotContext) {
        String key = slotContext.identifier() + slotContext.index();
        return ResourceLocation.fromNamespaceAndPath((String)"curios", (String)key);
    }

    public static void registerCurioPredicate(ResourceLocation resourceLocation, Predicate<SlotResult> validator) {
        SLOT_RESULT_PREDICATES.putIfAbsent(resourceLocation, validator);
    }

    public static Optional<Predicate<SlotResult>> getCurioPredicate(ResourceLocation resourceLocation) {
        return Optional.ofNullable(SLOT_RESULT_PREDICATES.get(resourceLocation));
    }

    public static Map<ResourceLocation, Predicate<SlotResult>> getCurioPredicates() {
        return ImmutableMap.copyOf(SLOT_RESULT_PREDICATES);
    }

    public static boolean testCurioPredicates(Set<ResourceLocation> predicates, SlotResult slotResult) {
        for (ResourceLocation id : predicates) {
            if (!CuriosApi.getCurioPredicate(id).map(slotResultPredicate -> slotResultPredicate.test(slotResult)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    static {
        CuriosImplMixinHooks.registerCurioPredicate(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"all"), slotResult -> true);
        CuriosImplMixinHooks.registerCurioPredicate(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"none"), slotResult -> false);
        CuriosImplMixinHooks.registerCurioPredicate(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"tag"), slotResult -> {
            String id = slotResult.slotContext().identifier();
            TagKey tag1 = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)id));
            TagKey tag2 = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"curio"));
            ItemStack stack = slotResult.stack();
            return stack.is(tag1) || stack.is(tag2);
        });
    }
}

