/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks.entity;

import com.kyanite.deeperdarker.content.DDBlockEntities;
import com.kyanite.deeperdarker.datagen.data.loot.DDChestLoot;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class CrystallizedAmberBlockEntity
extends BlockEntity {
    public boolean fossilizedEntity;
    private ItemStack loot = ItemStack.EMPTY;

    public CrystallizedAmberBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)DDBlockEntities.CRYSTALLIZED_AMBER.get(), pos, blockState);
    }

    public void generateFossil(Level level, BlockPos pos) {
        if (this.fossilizedEntity || this.loot != ItemStack.EMPTY) {
            return;
        }
        RandomSource random = RandomSource.create((long)pos.asLong());
        if (random.nextFloat() < 0.15f) {
            this.fossilizedEntity = true;
            return;
        }
        LootTable table = level.getServer().reloadableRegistries().getLootTable(DDChestLoot.CRYSTALLIZED_AMBER);
        ObjectArrayList list = table.getRandomItems(new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)this.getBlockPos().getCenter()).withParameter(LootContextParams.BLOCK_ENTITY, (Object)this).create(LootContextParamSets.CHEST));
        this.loot = (ItemStack)list.getFirst();
        this.setChanged();
    }

    public ItemStack getLoot() {
        return this.loot;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.put("item", this.loot.saveOptional(registries));
        tag.putBoolean("leech", this.fossilizedEntity);
        return tag;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("item")) {
            this.loot = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item"));
        }
        if (tag.contains("leech")) {
            this.fossilizedEntity = tag.getBoolean("leech");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("item", this.loot.saveOptional(registries));
        tag.putBoolean("leech", this.fossilizedEntity);
    }
}

