/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.datagen.assets;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDItems;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class DDItemModelProvider
extends ItemModelProvider {
    private final ModelFile GENERATED = this.getExistingFile(this.mcLoc("item/generated"));
    private final ModelFile HANDHELD = this.getExistingFile(this.mcLoc("item/handheld"));

    public DDItemModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "deeperdarker", exFileHelper);
    }

    protected void registerModels() {
        this.blockModel(DDBlocks.ECHO_LOG);
        this.blockModel(DDBlocks.ECHO_WOOD);
        this.blockModel(DDBlocks.STRIPPED_ECHO_LOG);
        this.blockModel(DDBlocks.STRIPPED_ECHO_WOOD);
        this.blockModel(DDBlocks.ECHO_PLANKS);
        this.blockModel(DDBlocks.ECHO_STAIRS);
        this.blockModel(DDBlocks.ECHO_SLAB);
        this.blockModel(DDBlocks.ECHO_FENCE, "inventory");
        this.blockModel(DDBlocks.ECHO_FENCE_GATE);
        this.itemModel((DeferredHolder<?, ?>)DDBlocks.ECHO_DOOR, this.GENERATED).renderType("translucent");
        this.blockModel(DDBlocks.ECHO_TRAPDOOR, "bottom");
        this.blockModel(DDBlocks.ECHO_PRESSURE_PLATE);
        this.blockModel(DDBlocks.ECHO_BUTTON, "inventory");
        this.blockModel(DDBlocks.ECHO_LEAVES);
        this.blockItemModel(DDBlocks.ECHO_SAPLING, DDBlocks.ECHO_SAPLING, this.GENERATED);
        this.blockModel(DDBlocks.BLOOMING_STEM, "inventory");
        this.blockModel(DDBlocks.STRIPPED_BLOOMING_STEM, "inventory");
        this.blockModel(DDBlocks.BLOOM_PLANKS);
        this.blockModel(DDBlocks.BLOOM_STAIRS);
        this.blockModel(DDBlocks.BLOOM_SLAB);
        this.blockModel(DDBlocks.BLOOM_FENCE, "inventory");
        this.blockModel(DDBlocks.BLOOM_FENCE_GATE);
        this.itemModel((DeferredHolder<?, ?>)DDBlocks.BLOOM_DOOR, this.GENERATED).renderType("translucent");
        this.blockModel(DDBlocks.BLOOM_TRAPDOOR, "bottom");
        this.blockModel(DDBlocks.BLOOM_PRESSURE_PLATE);
        this.blockModel(DDBlocks.BLOOM_BUTTON, "inventory");
        this.blockModel(DDBlocks.SCULK_STONE);
        this.blockModel(DDBlocks.SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE);
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE);
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.SCULK_STONE_BRICKS);
        this.blockModel(DDBlocks.SCULK_STONE_BRICK_STAIRS);
        this.blockModel(DDBlocks.SCULK_STONE_BRICK_SLAB);
        this.blockModel(DDBlocks.SCULK_STONE_BRICK_WALL, "inventory");
        this.blockModel(DDBlocks.SCULK_STONE_TILES);
        this.blockModel(DDBlocks.SCULK_STONE_TILE_STAIRS);
        this.blockModel(DDBlocks.SCULK_STONE_TILE_SLAB);
        this.blockModel(DDBlocks.SCULK_STONE_TILE_WALL, "inventory");
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE);
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.CUT_SCULK_STONE);
        this.blockModel(DDBlocks.CUT_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.CUT_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.CUT_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.CHISELED_SCULK_STONE);
        this.blockModel(DDBlocks.BLOOMING_SCULK_STONE);
        this.blockModel(DDBlocks.BLOOMING_MOSS_BLOCK);
        this.blockModel(DDBlocks.GLOOMSLATE);
        this.blockModel(DDBlocks.GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE);
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE);
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.GLOOMSLATE_BRICKS);
        this.blockModel(DDBlocks.GLOOMSLATE_BRICK_STAIRS);
        this.blockModel(DDBlocks.GLOOMSLATE_BRICK_SLAB);
        this.blockModel(DDBlocks.GLOOMSLATE_BRICK_WALL, "inventory");
        this.blockModel(DDBlocks.GLOOMSLATE_TILES);
        this.blockModel(DDBlocks.GLOOMSLATE_TILE_STAIRS);
        this.blockModel(DDBlocks.GLOOMSLATE_TILE_SLAB);
        this.blockModel(DDBlocks.GLOOMSLATE_TILE_WALL, "inventory");
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE);
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.CUT_GLOOMSLATE);
        this.blockModel(DDBlocks.CUT_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.CUT_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.CUT_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.CHISELED_GLOOMSLATE);
        this.blockModel(DDBlocks.SCULK_GRIME);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICKS);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICK_STAIRS);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICK_SLAB);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICK_WALL, "inventory");
        this.blockModel(DDBlocks.ECHO_SOIL);
        this.blockModel(DDBlocks.GLOOMY_SCULK);
        this.blockModel(DDBlocks.GLOOMY_GEYSER);
        this.blockModel(DDBlocks.CRYSTALLIZED_AMBER);
        this.blockModel(DDBlocks.SCULK_GLEAM);
        this.blockModel(DDBlocks.SOUNDPROOF_GLASS);
        this.blockModel(DDBlocks.SCULK_STONE_COAL_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_IRON_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_COPPER_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_GOLD_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_REDSTONE_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_EMERALD_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_LAPIS_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_DIAMOND_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_COAL_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_IRON_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_COPPER_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_GOLD_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_REDSTONE_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_EMERALD_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_LAPIS_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_DIAMOND_ORE);
        this.itemModel((DeferredHolder<?, ?>)DDBlocks.GLOWING_FLOWERS, this.GENERATED).renderType("cutout");
        this.blockItemModel(DDBlocks.GLOWING_GRASS, DDBlocks.GLOWING_GRASS, this.GENERATED);
        this.blockItemModel(DDBlocks.GLOOMY_GRASS, DDBlocks.GLOOMY_GRASS, this.GENERATED);
        this.blockModel(DDBlocks.GLOOMY_CACTUS);
        this.blockItemModel(DDBlocks.SCULK_TENDRILS, DDBlocks.SCULK_TENDRILS_PLANT, this.GENERATED);
        this.blockItemModel(DDBlocks.SCULK_VINES, DDBlocks.SCULK_VINES_PLANT, this.GENERATED);
        this.blockItemModel(DDBlocks.GLOWING_ROOTS, DDBlocks.GLOWING_ROOTS_PLANT, this.GENERATED);
        this.blockItemModel(DDBlocks.ICE_LILY, DDBlocks.ICE_LILY, this.GENERATED);
        this.blockItemModel(DDBlocks.LILY_FLOWER, DDBlocks.LILY_FLOWER, this.GENERATED);
        this.blockModel(DDBlocks.ANCIENT_VASE);
        this.withExistingParent(DDBlocks.INFESTED_SCULK.getId().getPath(), this.mcLoc("block/sculk"));
        this.blockModel(DDBlocks.SCULK_JAW);
        this.itemModelWithSuffix(DDItems.SOUL_ELYTRA, this.GENERATED, "broken");
        this.itemModel((DeferredHolder<?, ?>)DDItems.SOUL_ELYTRA, this.GENERATED).override().model((ModelFile)this.getModel(DDItems.SOUL_ELYTRA, "broken")).predicate(ResourceLocation.withDefaultNamespace((String)"broken"), 1.0f).end();
        this.itemModel((DeferredHolder<?, ?>)DDItems.ECHO_SIGN, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.ECHO_HANGING_SIGN, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.BLOOM_SIGN, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.BLOOM_HANGING_SIGN, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.ECHO_BOAT, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.ECHO_CHEST_BOAT, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.BLOOM_BOAT, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.BLOOM_CHEST_BOAT, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.BLOOM_BERRIES, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.GRIME_BALL, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.GRIME_BRICK, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.RESONARIUM_SHOVEL, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.RESONARIUM_PICKAXE, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.RESONARIUM_AXE, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.RESONARIUM_HOE, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.RESONARIUM_SWORD, this.HANDHELD);
        this.armorItemModel(DDItems.RESONARIUM_HELMET);
        this.armorItemModel(DDItems.RESONARIUM_CHESTPLATE);
        this.armorItemModel(DDItems.RESONARIUM_LEGGINGS);
        this.armorItemModel(DDItems.RESONARIUM_BOOTS);
        this.itemModel((DeferredHolder<?, ?>)DDItems.WARDEN_SHOVEL, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.WARDEN_PICKAXE, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.WARDEN_AXE, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.WARDEN_HOE, this.HANDHELD);
        this.itemModel((DeferredHolder<?, ?>)DDItems.WARDEN_SWORD, this.HANDHELD);
        this.armorItemModel(DDItems.WARDEN_HELMET);
        this.armorItemModel(DDItems.WARDEN_CHESTPLATE);
        this.armorItemModel(DDItems.WARDEN_LEGGINGS);
        this.armorItemModel(DDItems.WARDEN_BOOTS);
        this.itemModel((DeferredHolder<?, ?>)DDItems.SCULK_BONE, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.SOUL_DUST, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.SOUL_CRYSTAL, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.RESONARIUM, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.RESONARIUM_PLATE, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.HEART_OF_THE_DEEP, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.WARDEN_CARAPACE, this.GENERATED);
        this.itemModel((DeferredHolder<?, ?>)DDItems.REINFORCED_ECHO_SHARD, this.GENERATED);
        this.itemModelWithSuffix(DDItems.SCULK_TRANSMITTER, this.GENERATED, "on");
        this.itemModel((DeferredHolder<?, ?>)DDItems.SCULK_TRANSMITTER, this.GENERATED).override().model((ModelFile)this.getModel(DDItems.SCULK_TRANSMITTER, "on")).predicate(DeeperDarker.rl("linked"), 1.0f).end();
        this.itemModelWithSuffix(DDItems.SONOROUS_STAFF, this.HANDHELD, "charged");
        this.itemModelWithSuffix(DDItems.SONOROUS_STAFF, this.HANDHELD, "charging");
        this.itemModel((DeferredHolder<?, ?>)DDItems.SONOROUS_STAFF, this.HANDHELD).override().model((ModelFile)this.getModel(DDItems.SONOROUS_STAFF, "charging")).predicate(DeeperDarker.rl("charge"), 0.001f).end().override().model((ModelFile)this.getModel(DDItems.SONOROUS_STAFF, "charged")).predicate(DeeperDarker.rl("charge"), 1.0f).end();
        this.itemModel((DeferredHolder<?, ?>)DDItems.WARDEN_UPGRADE_SMITHING_TEMPLATE, this.GENERATED);
        this.spawnEggModel(DDItems.ANGLER_FISH_SPAWN_EGG);
        this.spawnEggModel(DDItems.SCULK_CENTIPEDE_SPAWN_EGG);
        this.spawnEggModel(DDItems.SCULK_LEECH_SPAWN_EGG);
        this.spawnEggModel(DDItems.SCULK_SNAPPER_SPAWN_EGG);
        this.spawnEggModel(DDItems.SHATTERED_SPAWN_EGG);
        this.spawnEggModel(DDItems.SHRIEK_WORM_SPAWN_EGG);
        this.spawnEggModel(DDItems.SLUDGE_SPAWN_EGG);
        this.spawnEggModel(DDItems.STALKER_SPAWN_EGG);
    }

    public void blockModel(DeferredBlock<? extends Block> block) {
        this.withExistingParent(block.getId().getPath(), this.modLoc("block/" + block.getId().getPath()));
    }

    public void blockModel(DeferredBlock<? extends Block> block, String suffix) {
        this.withExistingParent(block.getId().getPath(), this.modLoc("block/" + block.getId().getPath() + "_" + suffix));
    }

    public void blockItemModel(DeferredBlock<?> block, DeferredBlock<?> textureBlock, ModelFile modelFile) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(block.getId().getPath())).parent(modelFile)).texture("layer0", "block/" + textureBlock.getId().getPath());
    }

    public ItemModelBuilder itemModel(DeferredHolder<?, ?> item, ModelFile modelFile) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent(modelFile)).texture("layer0", "item/" + item.getId().getPath());
    }

    public void itemModelWithSuffix(DeferredItem<?> item, ModelFile modelFile, String suffix) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().getPath() + "_" + suffix)).parent(modelFile)).texture("layer0", "item/" + item.getId().getPath() + "_" + suffix);
    }

    private void armorItemModel(DeferredItem<? extends ArmorItem> item) {
        ItemModelBuilder itemModel = this.itemModel((DeferredHolder<?, ?>)item, this.GENERATED);
        for (ItemModelGenerators.TrimModelData trimModel : ItemModelGenerators.GENERATED_TRIM_MODELS) {
            ResourceLocation trimLoc = item.get() == DDItems.WARDEN_HELMET.get() ? this.modLoc("trims/items/warden_") : this.mcLoc("trims/items/");
            ResourceLocation trimLayer = ResourceLocation.parse((String)(String.valueOf(trimLoc) + ((ArmorItem)item.get()).getType().getName() + "_trim_" + trimModel.name()));
            this.existingFileHelper.trackGenerated(trimLayer, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().getPath() + "_" + trimModel.name() + "_trim")).parent(this.GENERATED)).texture("layer0", "item/" + item.getId().getPath())).texture("layer1", String.valueOf(trimLoc) + ((ArmorItem)item.get()).getType().getName() + "_trim_" + trimModel.name());
            itemModel.override().model((ModelFile)this.getModel(item, trimModel.name() + "_trim")).predicate(ItemModelGenerators.TRIM_TYPE_PREDICATE_ID, trimModel.itemModelIndex()).end();
        }
    }

    private void spawnEggModel(DeferredItem<Item> item) {
        this.withExistingParent(item.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
    }

    private ModelFile.ExistingModelFile getModel(DeferredItem<?> item, String suffix) {
        return new ModelFile.ExistingModelFile(this.modLoc("item/" + item.getId().getPath() + "_" + suffix), this.existingFileHelper);
    }
}

