/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.neoforge.NetworkPlatformToolsImpl;
import java.nio.ByteBuffer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class NetworkPlatformTools {
    public static final CustomPacketPayload.Type<EmotePacketPayload> EMOTE_CHANNEL_ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"emotecraft", (String)"emote"));
    public static final CustomPacketPayload.Type<EmotePacketPayload> STREAM_CHANNEL_ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"emotecraft", (String)"stream"));
    public static final CustomPacketPayload.Type<EmotePacketPayload> GEYSER_CHANNEL_ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"geyser", (String)"emote"));

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static boolean canSendPlay(ServerPlayer player, ResourceLocation channel) {
        void var1_1;
        return NetworkPlatformToolsImpl.canSendPlay(player, (ResourceLocation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static boolean canSendConfig(ServerConfigurationPacketListenerImpl player, ResourceLocation channel) {
        void var1_1;
        return NetworkPlatformToolsImpl.canSendConfig(player, (ResourceLocation)var1_1);
    }

    @NotNull
    public static Packet<?> createClientboundPacket(@NotNull CustomPacketPayload.Type<?> id, @NotNull ByteBuffer buf) {
        assert (buf.hasRemaining());
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)new EmotePacketPayload(id, buf));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getServer() {
        return NetworkPlatformToolsImpl.getServer();
    }

    @NotNull
    public static Packet<?> playPacket(@NotNull ByteBuffer buf) {
        return NetworkPlatformTools.createClientboundPacket(EMOTE_CHANNEL_ID, buf);
    }

    @NotNull
    public static Packet<?> streamPacket(@NotNull ByteBuffer buf) {
        return NetworkPlatformTools.createClientboundPacket(STREAM_CHANNEL_ID, buf);
    }

    @NotNull
    public static Packet<?> geyserPacket(@NotNull ByteBuffer buf) {
        return NetworkPlatformTools.createClientboundPacket(GEYSER_CHANNEL_ID, buf);
    }
}

