/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.components;

import io.github.kosmx.emotes.arch.gui.widgets.EmoteListWidget;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class EmoteSubScreen
extends Screen {
    private static final Component SEARCH = Component.translatable((String)"gui.recipebook.search_hint");
    protected Screen lastScreen;
    @Nullable
    protected EmoteListWidget list;
    protected HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

    protected EmoteSubScreen(Component title, Screen lastScreen) {
        super(title);
        this.lastScreen = lastScreen;
    }

    protected void init() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addTitle() {
        EditBox searchBox = (EditBox)this.layout.addToHeader((LayoutElement)new EditBox(this.font, 0, 0, 200, 20, (Component)Component.empty()));
        searchBox.setHint(SEARCH);
        searchBox.setResponder(string -> Objects.requireNonNull(this.list).filter(string::toLowerCase));
    }

    protected EmoteListWidget newEmoteListWidget() {
        return new EmoteListWidget(this.minecraft, this.width, this.layout.getContentHeight(), this.layout.getHeaderHeight(), 36){

            public void setSelected(@Nullable EmoteListWidget.EmoteEntry entry) {
                super.setSelected((AbstractSelectionList.Entry)entry);
                EmoteSubScreen.this.onPressed(entry);
            }
        };
    }

    protected void addContents() {
        this.list = (EmoteListWidget)this.layout.addToContents((LayoutElement)this.newEmoteListWidget());
        this.addOptions();
    }

    protected abstract void addOptions();

    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
    }

    protected abstract void onPressed(@Nullable EmoteListWidget.EmoteEntry var1);

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }
}

