/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.config;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.common.tools.BiMap;
import java.util.UUID;

public class ClientConfig
extends SerializableConfig {
    public final SerializableConfig.ConfigEntry<Boolean> dark;
    public final SerializableConfig.ConfigEntry<Boolean> oldChooseWheel;
    public final SerializableConfig.ConfigEntry<Boolean> enablePerspective;
    public final SerializableConfig.ConfigEntry<Boolean> frontAsTPPerspective;
    public final SerializableConfig.ConfigEntry<Boolean> showIcons;
    public final SerializableConfig.ConfigEntry<Boolean> enableNSFW;
    public final SerializableConfig.ConfigEntry<Boolean> checkPose;
    public final SerializableConfig.ConfigEntry<Boolean> alwaysOpenEmoteScreen;
    public final SerializableConfig.ConfigEntry<Boolean> alwaysValidate;
    public final SerializableConfig.ConfigEntry<Boolean> enablePlayerSafety;
    public final SerializableConfig.ConfigEntry<Float> stopThreshold;
    public final SerializableConfig.ConfigEntry<Float> yRatio;
    public final SerializableConfig.ConfigEntry<Boolean> showHiddenConfig;
    public final SerializableConfig.ConfigEntry<Boolean> neverRemoveBadIcon;
    public final SerializableConfig.ConfigEntry<Boolean> exportBuiltin;
    public BiMap<UUID, InputConstants.Key> emoteKeyMap;
    public UUID[][] fastMenuEmotes;
    public final SerializableConfig.ConfigEntry<Boolean> hideWarningMessage;

    public ClientConfig() {
        this.dark = new SerializableConfig.ConfigEntry<Boolean>("dark", Boolean.valueOf(false), false, this.basics);
        this.oldChooseWheel = new SerializableConfig.ConfigEntry<Boolean>("oldChooseWheel", Boolean.valueOf(false), false, this.basics);
        this.enablePerspective = new SerializableConfig.ConfigEntry<Boolean>("perspective", Boolean.valueOf(true), false, this.basics);
        this.frontAsTPPerspective = new SerializableConfig.ConfigEntry<Boolean>("default3rdPersonFront", Boolean.valueOf(false), false, this.basics);
        this.showIcons = new SerializableConfig.ConfigEntry<Boolean>("showicon", "showIcon", Boolean.valueOf(true), false, this.basics);
        this.enableNSFW = new SerializableConfig.ConfigEntry<Boolean>("enableNSFW", Boolean.valueOf(false), true, this.basics);
        this.checkPose = new SerializableConfig.ConfigEntry<Boolean>("checkPose", Boolean.valueOf(true), true, this.expert);
        this.alwaysOpenEmoteScreen = new SerializableConfig.ConfigEntry<Boolean>("alwaysOpenScreen", Boolean.valueOf(false), true, this.basics);
        this.alwaysValidate = new SerializableConfig.ConfigEntry<Boolean>("alwaysValidateEmote", Boolean.valueOf(false), true, this.expert);
        this.enablePlayerSafety = new SerializableConfig.ConfigEntry<Boolean>("playersafety", Boolean.valueOf(true), true, this.expert);
        this.stopThreshold = new SerializableConfig.FloatConfigEntry(this, "stopthreshold", "stopThreshold", Float.valueOf(0.04f), true, this.expert, "options.generic_value", -3.912f, 8.0f, 0.0f){

            @Override
            public double getConfigVal() {
                return Math.log(((Float)this.get()).floatValue());
            }

            @Override
            public void setConfigVal(double newVal) {
                this.set(Float.valueOf((float)Math.exp(newVal)));
            }
        };
        this.yRatio = new SerializableConfig.FloatConfigEntry(this, "yratio", "yRatio", Float.valueOf(0.75f), true, this.expert, "options.percent_value", 0.0f, 100.0f, 1.0f){

            @Override
            public double getConfigVal() {
                return ((Float)this.get()).floatValue() * 100.0f;
            }

            @Override
            public void setConfigVal(double newVal) {
                this.set(Float.valueOf((float)(newVal / 100.0)));
            }

            @Override
            public double getTextVal() {
                return this.getConfigVal();
            }
        };
        this.showHiddenConfig = new SerializableConfig.ConfigEntry<Boolean>("showHiddenConfig", false, true, this.expert, false);
        this.neverRemoveBadIcon = new SerializableConfig.ConfigEntry<Boolean>("neverRemoveBadIcon", Boolean.valueOf(false), this.expert, true);
        this.exportBuiltin = new SerializableConfig.ConfigEntry<Boolean>("exportBuiltin", Boolean.valueOf(false), this.expert, true);
        this.emoteKeyMap = new BiMap();
        this.fastMenuEmotes = new UUID[10][8];
        this.hideWarningMessage = new SerializableConfig.ConfigEntry<Boolean>("hideWarning", Boolean.valueOf(false), this.expert, true);
        this.loadEmotesServerSide.set(false);
    }
}

