/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.task.file;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.capture.task.FileCaptureTask;
import io.github.mortuusars.exposure.client.capture.task.file.ImageFileLoader;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.WrappedNativeImage;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NativeImagePngFileLoader
implements ImageFileLoader {
    @Override
    public Result<Image> load(File file) {
        Result<Image> result;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            result = Result.success(new WrappedNativeImage(NativeImage.read((NativeImage.Format)NativeImage.Format.RGBA, (InputStream)inputStream)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Exposure.LOGGER.error("Loading image from file path '{}' failed:", (Object)file, (Object)e);
                return Result.error(FileCaptureTask.ERROR_CANNOT_READ);
            }
        }
        inputStream.close();
        return result;
    }
}

