/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.pipeline.RenderTarget;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderCameraControlsScreen;
import io.github.mortuusars.exposure.client.capture.task.BackgroundScreenshotCaptureTask;
import io.github.mortuusars.exposure.event.ClientEvents;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.serverbound.ActiveCameraReleaseC2SP;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    @Nullable
    public Screen screen;

    @Inject(method={"startUseItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isHandsBusy()Z")}, cancellable=true)
    void onStartUseItem(CallbackInfo ci) {
        CameraOnStand cameraOnStand;
        if (this.player == null || this.player.isHandsBusy()) {
            return;
        }
        if (this.screen instanceof ViewfinderCameraControlsScreen) {
            return;
        }
        Camera camera = this.player.getActiveExposureCamera();
        if (camera instanceof CameraOnStand && (cameraOnStand = (CameraOnStand)camera).isActive()) {
            cameraOnStand.release();
            Packets.sendToServer(ActiveCameraReleaseC2SP.INSTANCE);
            ci.cancel();
        }
    }

    @Inject(method={"startAttack()Z"}, at={@At(value="HEAD")}, cancellable=true)
    void onStartAttack(CallbackInfoReturnable<Boolean> cir) {
        if (this.player != null && this.player.getActiveExposureCamera() instanceof CameraOnStand) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;added()V")})
    void onSetScreen(Screen screen, CallbackInfo ci) {
        if (this.player != null && CameraClient.isActive() && !(screen instanceof ViewfinderCameraControlsScreen)) {
            CameraClient.deactivate();
        }
    }

    @Inject(method={"setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/gui/screens/ReceivingLevelScreen$Reason;)V"}, at={@At(value="HEAD")})
    void onLevelUnload(ClientLevel newLevel, ReceivingLevelScreen.Reason reason, CallbackInfo ci) {
        if (this.level != null) {
            ClientEvents.levelUnloaded();
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetData()V", shift=At.Shift.AFTER)})
    void disconnect(Screen nextScreen, boolean keepResourcePacks, CallbackInfo ci) {
        ClientEvents.disconnect();
    }

    @ModifyReturnValue(method={"getMainRenderTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;"}, at={@At(value="RETURN")})
    RenderTarget onGetMainRenderTarget(RenderTarget original) {
        if (BackgroundScreenshotCaptureTask.isCapturing()) {
            return BackgroundScreenshotCaptureTask.getRenderTarget();
        }
        return original;
    }
}

