/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.item.FilmItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class DevelopedFilmItem
extends Item
implements FilmItem {
    private final ExposureType type;

    public DevelopedFilmItem(ExposureType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Override
    public ExposureType getType() {
        return this.type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int frameSize;
        int exposedFrames = this.getStoredFramesCount(stack);
        if (exposedFrames > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.exposure.developed_film.tooltip.frame_count", (Object[])new Object[]{exposedFrames}).withStyle(ChatFormatting.GRAY));
        }
        if ((frameSize = this.getFrameSize(stack)) != this.getDefaultFrameSize(stack)) {
            tooltipComponents.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.frame_size", (Object[])new Object[]{Component.literal((String)String.format("%.1f", Float.valueOf((float)frameSize / 10.0f)))}).withStyle(ChatFormatting.GRAY));
        }
    }
}

