/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.Filter;
import io.github.mortuusars.exposure.data.Filters;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShutterOpenedS2CP;
import io.github.mortuusars.exposure.network.packet.serverbound.OpenCameraAttachmentsInCreativePacketC2SP;
import io.github.mortuusars.exposure.server.CameraInstance;
import io.github.mortuusars.exposure.server.CameraInstances;
import io.github.mortuusars.exposure.util.ExtraData;
import io.github.mortuusars.exposure.util.PointOfView;
import io.github.mortuusars.exposure.util.TranslatableError;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.util.Vec3Util;
import io.github.mortuusars.exposure.util.color.Color;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.CameraInHand;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.camera.capture.CaptureType;
import io.github.mortuusars.exposure.world.camera.capture.Projection;
import io.github.mortuusars.exposure.world.camera.component.FocalRange;
import io.github.mortuusars.exposure.world.camera.component.SelfTimer;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmProperties;
import io.github.mortuusars.exposure.world.camera.frame.EntitiesInFrame;
import io.github.mortuusars.exposure.world.camera.frame.EntityInFrame;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.camera.frame.Photographer;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import io.github.mortuusars.exposure.world.inventory.CameraInHandAttachmentsMenu;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.InterplanarProjectorItem;
import io.github.mortuusars.exposure.world.item.SensitiveFilmItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.item.camera.Flash;
import io.github.mortuusars.exposure.world.item.camera.Shutter;
import io.github.mortuusars.exposure.world.item.camera.Timer;
import io.github.mortuusars.exposure.world.item.component.StoredItemStack;
import io.github.mortuusars.exposure.world.level.LevelUtil;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure.world.sound.Sound;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class CameraItem
extends Item {
    public static final int BASE_COOLDOWN = 2;
    public static final int PROJECT_COOLDOWN = 20;
    protected final Shutter shutter = this.createShutter();
    protected final Timer timer = this.createTimer();
    protected final Flash flash = this.createFlash();
    protected final List<Attachment<?>> attachments = this.defineAttachments();
    protected final List<ShutterSpeed> availableShutterSpeeds = this.defineShutterSpeeds();

    public CameraItem(Item.Properties properties) {
        super(properties);
        this.shutter.onOpen((TriConsumer<CameraHolder, ServerLevel, ItemStack>)((TriConsumer)this::onShutterOpen));
        this.shutter.onClosed((TriConsumer<CameraHolder, ServerLevel, ItemStack>)((TriConsumer)this::onShutterClosed));
    }

    protected Shutter createShutter() {
        return new Shutter();
    }

    protected Timer createTimer() {
        return new Timer();
    }

    protected Flash createFlash() {
        return new Flash();
    }

    @NotNull
    protected List<Attachment<?>> defineAttachments() {
        return List.of(Attachment.FILM, Attachment.FLASH, Attachment.LENS, Attachment.FILTER);
    }

    protected List<ShutterSpeed> defineShutterSpeeds() {
        return List.of(new ShutterSpeed("1/500"), new ShutterSpeed("1/250"), new ShutterSpeed("1/125"), new ShutterSpeed("1/60"), new ShutterSpeed("1/30"), new ShutterSpeed("1/15"), new ShutterSpeed("1/8"), new ShutterSpeed("1/4"), new ShutterSpeed("1/2"), new ShutterSpeed("1\""));
    }

    public boolean hasAttachmentsMenu() {
        return true;
    }

    public Shutter getShutter() {
        return this.shutter;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Flash getFlash() {
        return this.flash;
    }

    public List<ShutterSpeed> getAvailableShutterSpeeds() {
        return this.availableShutterSpeeds;
    }

    public List<Attachment<?>> getAttachments() {
        return this.attachments;
    }

    public Attachment<?> getFilmAttachment() {
        return Attachment.FILM;
    }

    @NotNull
    public FilmProperties getFilmProperties(ItemStack stack) {
        ItemStack filmStack = this.getFilmAttachment().get(stack).getForReading();
        Item item = filmStack.getItem();
        if (!(item instanceof SensitiveFilmItem)) {
            throw new IllegalStateException("Cannot take a photo without SensitiveFilmItem in the camera. stack: " + String.valueOf(stack));
        }
        SensitiveFilmItem filmItem = (SensitiveFilmItem)item;
        return filmItem.getFilmProperties(filmStack);
    }

    public SoundEvent getViewfinderOpenSound() {
        return Exposure.SoundEvents.VIEWFINDER_OPEN.get();
    }

    public SoundEvent getViewfinderCloseSound() {
        return Exposure.SoundEvents.VIEWFINDER_CLOSE.get();
    }

    public SoundEvent getReleaseButtonSound() {
        return Exposure.SoundEvents.CAMERA_RELEASE_BUTTON_CLICK.get();
    }

    public ResourceLocation getCaptureType(ItemStack stack) {
        return CaptureType.CAMERA;
    }

    public double getSelfieCameraDistance(ItemStack stack) {
        return (Double)Config.Server.SELFIE_CAMERA_DISTANCE.get();
    }

    public double getYPositionOffset(ItemStack stack) {
        return (Boolean)Config.Server.WAIST_LEVEL_VIEWFINDER.get() != false ? -0.35 : 0.0;
    }

    public float getScaleOnStand() {
        return 0.9f;
    }

    public float getCropFactor() {
        return 0.875f;
    }

    public FocalRange getFocalRange(RegistryAccess registryAccess, ItemStack stack) {
        return Attachment.LENS.map(stack, lensStack -> Lenses.getFocalRangeOrDefault(registryAccess, lensStack)).orElse(FocalRange.getDefault());
    }

    public double getFov(Level level, ItemStack stack) {
        double zoom = CameraSettings.ZOOM.getOrDefault(stack).floatValue();
        FocalRange focalRange = this.getFocalRange(level.registryAccess(), stack);
        return focalRange.fovFromZoom(zoom);
    }

    public double getViewfinderFov(Level level, ItemStack stack) {
        return this.getFov(level, stack) * (double)this.getCropFactor();
    }

    public PointOfView getPointOfView(CameraHolder holder, ItemStack stack) {
        if (this.isInSelfieMode(stack)) {
            return PointOfView.of(holder).reverseDirection().limitMaxDistance(holder, this.getSelfieCameraDistance(stack)).rotateX(-CameraSettings.SELFIE_ROTATION_X.getOrDefault(stack).doubleValue()).rotateY(-CameraSettings.SELFIE_ROTATION_Y.getOrDefault(stack).doubleValue());
        }
        return PointOfView.of(holder).move(0.0, this.getYPositionOffset(stack), 0.0);
    }

    public Optional<Filter> getFilter(RegistryAccess registryAccess, ItemStack stack) {
        return Attachment.FILTER.map(stack, filter -> Filters.of(registryAccess, filter)).flatMap(Function.identity());
    }

    public Optional<ResourceLocation> getFilterShaderLocation(RegistryAccess registryAccess, ItemStack stack) {
        return this.getFilter(registryAccess, stack).map(Filter::shader);
    }

    protected Optional<ColorChannel> getChromaticChannel(ItemStack stack) {
        return Attachment.FILTER.map(stack, ColorChannel::fromFilterStack).orElse(Optional.empty());
    }

    protected Optional<Projection> getProjection(ItemStack stack) {
        return Attachment.FILTER.map(stack, (filterItem, filterStack) -> {
            Optional<Object> optional;
            if (filterItem instanceof InterplanarProjectorItem) {
                InterplanarProjectorItem projectorItem = (InterplanarProjectorItem)((Object)filterItem);
                optional = projectorItem.getProjection((ItemStack)filterStack);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).orElse(Optional.empty());
    }

    public CameraId getOrCreateId(ItemStack stack) {
        if (!stack.has(Exposure.DataComponents.CAMERA_ID)) {
            stack.set(Exposure.DataComponents.CAMERA_ID, (Object)CameraId.create());
        }
        return (CameraId)stack.get(Exposure.DataComponents.CAMERA_ID);
    }

    public boolean isInSelfieMode(ItemStack stack) {
        return CameraSettings.SELFIE_MODE.getOrDefault(stack);
    }

    public boolean isActive(ItemStack stack) {
        return (Boolean)stack.getOrDefault(Exposure.DataComponents.CAMERA_ACTIVE, (Object)false);
    }

    public void setActive(ItemStack stack, boolean active) {
        if (!active) {
            stack.remove(Exposure.DataComponents.CAMERA_ACTIVE);
        } else {
            stack.set(Exposure.DataComponents.CAMERA_ACTIVE, (Object)true);
        }
    }

    public boolean isDisassembled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(Exposure.DataComponents.CAMERA_DISASSEMBLED, (Object)false);
    }

    public void setDisassembled(ItemStack stack, boolean disassembled) {
        if (!disassembled) {
            stack.remove(Exposure.DataComponents.CAMERA_DISASSEMBLED);
        } else {
            stack.set(Exposure.DataComponents.CAMERA_DISASSEMBLED, (Object)true);
        }
    }

    public long getLastActionTime(ItemStack stack) {
        return (Long)stack.getOrDefault(Exposure.DataComponents.CAMERA_LAST_ACTION_TIME, (Object)-1L);
    }

    public void setLastActionTime(ItemStack stack, long lastActionTime) {
        stack.set(Exposure.DataComponents.CAMERA_LAST_ACTION_TIME, (Object)lastActionTime);
    }

    public void actionPerformed(ItemStack stack, CameraHolder holder) {
        this.setLastActionTime(stack, holder.asHolderEntity().level().getGameTime());
        holder.asHolderEntity().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> activateInHand(Player player, ItemStack stack, @NotNull InteractionHand hand) {
        player.setActiveExposureCamera((Camera)new CameraInHand((CameraHolder)player, this.getOrCreateId(stack), hand));
        if (player.level().isClientSide) {
            Minecrft.releaseUseButton();
        }
        return this.activate((Entity)player, stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> activateOnStand(Player player, ItemStack stack, CameraStandEntity cameraStand) {
        player.setActiveExposureCamera((Camera)new CameraOnStand((CameraOperator)player, cameraStand, this.getOrCreateId(stack)));
        if (player.level().isClientSide) {
            Minecrft.releaseUseButton();
        }
        return this.activate((Entity)player, stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> activate(Entity entity, ItemStack stack) {
        this.setActive(stack, true);
        this.setDisassembled(stack, false);
        Sound.play(entity, this.getViewfinderOpenSound(), entity.getSoundSource(), 0.35f, 0.9f, 0.2f);
        entity.gameEvent((Holder)GameEvent.EQUIP);
        return InteractionResultHolder.consume((Object)stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> deactivate(Entity entity, ItemStack stack) {
        this.setActive(stack, false);
        CameraSettings.SELFIE_MODE.set(stack, (Boolean)false);
        Sound.play(entity, this.getViewfinderCloseSound(), entity.getSoundSource(), 0.35f, 0.9f, 0.2f);
        entity.gameEvent((Holder)GameEvent.EQUIP);
        return InteractionResultHolder.consume((Object)stack);
    }

    public int calculateCooldownAfterShot(ItemStack stack, CaptureParameters captureParameters) {
        if (captureParameters.projection().isPresent()) {
            return 20;
        }
        if (captureParameters.getFlash()) {
            return this.getFlash().getCooldown();
        }
        return 2;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return (Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get() != false && Attachment.FILM.map(stack, FilmRollItem::isBarVisible).orElse(false) != false;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return Attachment.FILM.map(stack, FilmRollItem::getBarWidth).orElse(0);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return Attachment.FILM.map(stack, FilmRollItem::getBarColor).orElse(0);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        if (((Boolean)Config.Client.CAMERA_SHOW_FILM_FRAMES_IN_TOOLTIP.get()).booleanValue()) {
            Attachment.FILM.ifPresent(stack, (filmItem, filmStack) -> {
                int exposed = filmItem.getStoredFramesCount(filmStack);
                int max = filmItem.getMaxFrameCount(filmStack);
                components.add((Component)Component.translatable((String)"item.exposure.camera.tooltip.film_roll_frames", (Object[])new Object[]{exposed, max}));
            });
        }
        if (((Boolean)Config.Client.CAMERA_SHOW_TOOLTIP_DETAILS.get()).booleanValue()) {
            if (stack.getEntityRepresentation() instanceof CameraStandEntity) {
                if (Screen.hasShiftDown()) {
                    components.add((Component)Component.translatable((String)"item.exposure.camera.tooltip.details_attachments_screen_on_stand"));
                    components.add((Component)Component.translatable((String)"item.exposure.camera.tooltip.details_hotswap_on_stand"));
                } else {
                    components.add((Component)Component.translatable((String)"tooltip.exposure.hold_for_details"));
                }
                return;
            }
            boolean rClickAttachments = (Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_OPEN_ATTACHMENTS.get();
            boolean rClickHotswap = (Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get();
            if (rClickAttachments || rClickHotswap) {
                if (Screen.hasShiftDown()) {
                    if (rClickAttachments) {
                        components.add((Component)Component.translatable((String)"item.exposure.camera.tooltip.details_attachments_screen"));
                    }
                    if (rClickHotswap) {
                        components.add((Component)Component.translatable((String)"item.exposure.camera.tooltip.details_hotswap"));
                    }
                } else {
                    components.add((Component)Component.translatable((String)"tooltip.exposure.hold_for_details"));
                }
            }
        }
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (this.getShutter().isOpen(stack)) {
            player.playSound(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 0.9f, 1.0f);
            player.displayClientMessage((Component)Component.translatable((String)"item.exposure.camera.camera_attachments.fail.shutter_open").withStyle(ChatFormatting.RED), true);
            return true;
        }
        if (otherStack.isEmpty() && ((Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_OPEN_ATTACHMENTS.get()).booleanValue()) {
            if (!(slot.container instanceof Inventory)) {
                return false;
            }
            if (player.isCreative() && player.level().isClientSide()) {
                Packets.sendToServer(new OpenCameraAttachmentsInCreativePacketC2SP(slot.getContainerSlot()));
                return true;
            }
            this.openCameraAttachments(player, slot.getContainerSlot(), true);
            return true;
        }
        return (Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get() != false && this.hotswap((CameraHolder)player, stack, otherStack, access) != InteractionResult.PASS;
    }

    public InteractionResult handleStandSneakInteraction(CameraStandEntity stand, Player player, InteractionHand hand, ItemStack cameraStack) {
        ItemStack itemInHand = player.getItemInHand(hand);
        int slot = hand == InteractionHand.OFF_HAND ? 40 : player.getInventory().selected;
        SlotAccess access = SlotAccess.forContainer((Container)player.getInventory(), (int)slot);
        return this.hotswap(stand, cameraStack, itemInHand, access);
    }

    protected InteractionResult hotswap(CameraHolder holder, ItemStack stack, ItemStack otherStack, SlotAccess access) {
        for (Attachment<?> attachment : this.getAttachments()) {
            StoredItemStack storedStack = attachment.get(stack);
            int maxCount = attachment.maxCount().get();
            if (otherStack.isEmpty()) {
                if (storedStack.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                access.set(storedStack.getCopy());
                attachment.set(stack, ItemStack.EMPTY);
                attachment.playRemoveSoundSided(holder.asHolderEntity());
                return InteractionResult.SUCCESS;
            }
            if (!attachment.matches(otherStack)) continue;
            if (storedStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)storedStack.getForReading(), (ItemStack)otherStack)) {
                int availableCount = Math.max(0, maxCount - storedStack.getForReading().getCount());
                if (availableCount == 0) {
                    holder.asHolderEntity().playSound(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 0.9f, 1.0f);
                    return InteractionResult.FAIL;
                }
                ItemStack insertedStack = otherStack.split(availableCount);
                insertedStack.setCount(insertedStack.getCount() + storedStack.getForReading().getCount());
                attachment.set(stack, insertedStack);
                access.set(otherStack);
                attachment.playInsertSoundSided(holder.asHolderEntity());
                return InteractionResult.SUCCESS;
            }
            if (otherStack.getCount() > maxCount) {
                holder.asHolderEntity().playSound(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 0.9f, 1.0f);
                return InteractionResult.FAIL;
            }
            ItemStack returnedStack = storedStack.getCopy();
            attachment.set(stack, otherStack);
            access.set(returnedStack);
            attachment.playInsertSoundSided(holder.asHolderEntity());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> openCameraAttachments(@NotNull Player player, ItemStack stack, boolean openedFromGUI) {
        Preconditions.checkArgument((boolean)(stack.getItem() instanceof CameraItem), (String)"%s is not a CameraItem.", (Object)stack);
        int cameraSlot = this.getMatchingSlotInInventory(player.getInventory(), stack);
        if (cameraSlot < 0) {
            Exposure.LOGGER.error("Cannot open camera attachments: slot index is not found for item '{}'.", (Object)stack);
            return InteractionResultHolder.fail((Object)stack);
        }
        return this.openCameraAttachments(player, cameraSlot, openedFromGUI);
    }

    public InteractionResultHolder<ItemStack> openCameraAttachments(@NotNull Player player, final int slotIndex, final boolean openedFromGUI) {
        Preconditions.checkArgument((slotIndex >= 0 ? 1 : 0) != 0, (String)"slotIndex '%s' is invalid. Should be larger than 0", (int)slotIndex);
        final ItemStack stack = player.getInventory().getItem(slotIndex);
        Preconditions.checkArgument((boolean)(stack.getItem() instanceof CameraItem), (String)"Item in slotIndex '%s' is not a CameraItem but '%s'.", (int)slotIndex, (Object)stack);
        if (this.getShutter().isOpen(stack)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.exposure.camera.camera_attachments.fail.shutter_open").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        this.getOrCreateId(stack);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.getTimer().stop(stack);
            MenuProvider menuProvider = new MenuProvider(){

                @NotNull
                public Component getDisplayName() {
                    return stack.get(DataComponents.CUSTOM_NAME) != null ? stack.getHoverName() : Component.translatable((String)"container.exposure.camera");
                }

                @NotNull
                public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new CameraInHandAttachmentsMenu(containerId, playerInventory, slotIndex, openedFromGUI);
                }
            };
            PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> {
                buffer.writeInt(slotIndex);
                buffer.writeBoolean(openedFromGUI);
            });
        }
        this.setDisassembled(stack, true);
        Sound.play((Entity)player, Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), SoundSource.PLAYERS, 0.9f, 0.9f, 0.2f);
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(entity instanceof CameraHolder)) {
            return;
        }
        CameraHolder holder = (CameraHolder)entity;
        this.tick(holder, stack);
        if (level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            boolean matchesActive = player.getActiveExposureCameraOptional().map(camera -> camera.idMatches(this.getOrCreateId(stack))).orElse(false);
            if (this.isActive(stack) && !matchesActive) {
                this.setActive(stack, false);
            }
        }
    }

    public boolean tick(CameraHolder holder, ItemStack stack) {
        Level level = holder.asHolderEntity().level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean shutterStateChanged = this.getShutter().tick(holder, serverLevel, stack);
        boolean timerChanged = this.getTimer().tick(holder, serverLevel, stack);
        if (((Boolean)Config.Server.TIMER_ATTRACTS_MOB_ATTENTION.get()).booleanValue() && this.getTimer().isTicking(holder, stack) || this.getTimer().getTicksSinceLastRelease(holder, stack) < 10L) {
            this.grabAttentionOfNearbyMobs(holder, stack);
        }
        boolean projectionChanged = CameraInstances.getOptional(stack).map(instance -> {
            CameraInstance.ProjectionState state = instance.getProjectionState(level);
            switch (state) {
                case SUCCESSFUL: 
                case FAILED: 
                case TIMED_OUT: {
                    this.handleProjectionResult(serverLevel, holder, stack, state, instance.getProjectionError(level));
                    instance.stopWaitingForProjection();
                    return true;
                }
            }
            return false;
        }).orElse(false);
        if (ExposureServer.debugHighlightEntitiesInFrame && this.isActive(stack)) {
            this.testEntitiesInFrame(stack, level, holder);
        }
        return shutterStateChanged || timerChanged || projectionChanged;
    }

    protected void grabAttentionOfNearbyMobs(CameraHolder holder, ItemStack stack) {
        Entity holderEntity = holder.asHolderEntity();
        Vec3 pos = this.isInSelfieMode(stack) ? holderEntity.getEyePosition().add(holderEntity.getLookAngle().scale(((Double)Config.Server.SELFIE_CAMERA_DISTANCE.get()).doubleValue())) : holderEntity.getEyePosition();
        holderEntity.level().getEntities(holderEntity, new AABB(holderEntity.blockPosition()).inflate((double)((Integer)Config.Server.TIMER_ATTENTION_RADIUS.get()).intValue())).stream().filter(entity -> entity instanceof Mob).map(entity -> (Mob)entity).filter(mob -> this.canGrabAttentionOf(holder, (Mob)mob)).forEach(mob -> {
            long startLookingTick = this.getTimer().getStartTick(stack) + (long)(mob.getId() % 15);
            if (mob.level().getGameTime() > startLookingTick) {
                mob.lookAt(EntityAnchorArgument.Anchor.EYES, pos);
            }
        });
    }

    protected boolean canGrabAttentionOf(CameraHolder holder, Mob mob) {
        return mob.isAlive() && !mob.isDeadOrDying() && !mob.isSleeping() && !mob.getType().is(Exposure.Tags.Entities.IGNORES_CAMERA) && (mob.getTarget() == null || mob.getTarget().equals((Object)holder)) && !mob.hasEffect(MobEffects.BLINDNESS) && mob.hasLineOfSight(holder.asHolderEntity());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        CameraItem offhandCameraItem;
        Item item;
        ItemStack stack = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && (item = player.getOffhandItem().getItem()) instanceof CameraItem && (offhandCameraItem = (CameraItem)item).isActive(player.getOffhandItem())) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!this.isActive(stack)) {
            return player.isSecondaryUseActive() ? this.openCameraAttachments(player, stack, false) : this.activateInHand(player, stack, hand);
        }
        return this.release((CameraHolder)player, stack);
    }

    public boolean canTakePhoto(CameraHolder holder, ItemStack stack) {
        return !this.isOnCooldown(holder, stack) && !this.getTimer().isTicking(holder, stack) && !this.getShutter().isOpen(stack) && Attachment.FILM.map(stack, FilmRollItem::canAddFrame).orElse(false) != false && CameraInstances.canReleaseShutter(CameraId.ofStack(stack));
    }

    public boolean isOnCooldown(CameraHolder holder, ItemStack stack) {
        Entity entity = holder.asHolderEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getCooldowns().isOnCooldown((Item)this);
        }
        if (holder instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)holder;
            return stand.isOnCooldown();
        }
        return false;
    }

    public float getCooldownPercent(CameraHolder holder, ItemStack stack) {
        Entity entity = holder.asHolderEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getCooldowns().isOnCooldown(stack.getItem()) ? player.getCooldowns().getCooldownPercent(stack.getItem(), 0.0f) : 0.0f;
        }
        if (holder instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)holder;
            return stand.isOnCooldown() ? stand.getCooldownPercent() : 0.0f;
        }
        return 0.0f;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> release(CameraHolder holder, ItemStack stack) {
        SelfTimer selfTimer;
        Entity entity = holder.asHolderEntity();
        Level level = entity.level();
        Sound.playSided(entity, this.getReleaseButtonSound(), entity.getSoundSource(), 0.3f, 1.0f, 0.1f);
        if (level.isClientSide || !this.canTakePhoto(holder, stack)) {
            return InteractionResultHolder.consume((Object)stack);
        }
        if (this.getTimer().getEndTick(stack) != level.getGameTime() && (selfTimer = CameraSettings.SELF_TIMER.getOrDefault(stack)) != SelfTimer.OFF) {
            this.getTimer().set(holder, stack, selfTimer.getTicks());
            return InteractionResultHolder.consume((Object)stack);
        }
        holder.getServerPlayerExecutingExposure().ifPresentOrElse(player -> this.takePhoto(holder, (ServerPlayer)player, stack), () -> Exposure.LOGGER.error("Cannot start capture: photographer '{}' does not have valid executing player.", (Object)holder));
        return InteractionResultHolder.consume((Object)stack);
    }

    protected void takePhoto(CameraHolder holder, ServerPlayer executingPlayer, ItemStack stack) {
        ServerLevel level = executingPlayer.serverLevel();
        Entity entity = holder.asHolderEntity();
        ShutterSpeed shutterSpeed = CameraSettings.SHUTTER_SPEED.getOrDefault(stack);
        this.getShutter().open(holder, level, stack, shutterSpeed);
        CameraId cameraId = this.getOrCreateId(stack);
        String exposureId = ExposureIdentifier.createId((Entity)executingPlayer, new String[0]);
        int lightLevel = LevelUtil.getLightLevelAt((Level)level, entity.blockPosition());
        boolean flash = this.getFlash().isAvailable(stack) && this.getFlash().shouldFire(stack, lightLevel) && this.getFlash().fire(holder, level, stack);
        CaptureParameters captureParameters = new CaptureParameters.Builder(exposureId).setCameraID(cameraId).setCameraHolder(holder).setFov(this.getFov((Level)level, stack)).setCropFactor(this.getCropFactor()).setFilter(this.getFilterShaderLocation(level.registryAccess(), stack).orElse(null)).setProjection(this.getProjection(stack)).setChromaticChannel(this.getChromaticChannel(stack)).setFilmProperties(this.getFilmProperties(stack)).extraData(CaptureParameters.SHUTTER_SPEED, CameraSettings.SHUTTER_SPEED.getOrDefault(stack)).extraData(CaptureParameters.FLASH, flash).extraData(CaptureParameters.LIGHT_LEVEL, lightLevel).build();
        if (shutterSpeed.shouldCauseTickingSound() || captureParameters.projection().isPresent()) {
            int duration = Math.max(shutterSpeed.getDurationTicks(), captureParameters.projection().map(l -> (Integer)Config.Server.PROJECT_TIMEOUT_TICKS.get()).orElse(0));
            Sound.playShutterTicking(entity, cameraId, duration);
        }
        CameraInstances.createOrUpdate(cameraId, instance -> {
            int cooldown = this.calculateCooldownAfterShot(stack, captureParameters);
            instance.setDeferredCooldown(cooldown);
            captureParameters.projection().ifPresent(fileLoading -> instance.waitForProjection(level.getGameTime() + (long)((Integer)Config.Server.PROJECT_TIMEOUT_TICKS.get()).intValue()));
        });
        this.addNewFrame(level, holder, stack, captureParameters);
        ExposureServer.exposureRepository().expect(executingPlayer, exposureId);
        Packets.sendToClient(new CaptureStartS2CP(this.getCaptureType(stack), captureParameters), executingPlayer);
    }

    protected void onShutterOpen(CameraHolder holder, ServerLevel serverLevel, ItemStack stack) {
        holder.getExposureCameraOperator().ifPresent(operator -> {
            if (operator instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)operator;
                Packets.sendToClient(ShutterOpenedS2CP.INSTANCE, player);
            }
        });
    }

    protected void onShutterClosed(CameraHolder holder, ServerLevel serverLevel, ItemStack stack) {
        if (holder instanceof Player) {
            Player player = (Player)holder;
            int cooldown = CameraInstances.getOptional(stack).map(CameraInstance::getDeferredCooldown).orElse(2);
            player.getCooldowns().addCooldown((Item)this, cooldown);
        } else if (holder instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)holder;
            int cooldown = CameraInstances.getOptional(stack).map(CameraInstance::getDeferredCooldown).orElse(2);
            stand.startCooldown(cooldown);
        }
        Attachment.FILM.ifPresent(stack, (filmItem, filmStack) -> {
            SoundEvent sound = filmItem.isFull(filmStack) ? Exposure.SoundEvents.FILM_ADVANCE_LAST.get() : Exposure.SoundEvents.FILM_ADVANCE.get();
            float fullness = filmItem.getFullness(filmStack);
            String id = holder.asHolderEntity().getId() + this.getOrCreateId(stack).uuid().toString();
            Sound.playUnique(id, holder.asHolderEntity(), sound, SoundSource.PLAYERS, 1.0f, 0.85f + 0.2f * fullness);
        });
    }

    public void addNewFrame(ServerLevel level, CameraHolder holder, ItemStack stack, CaptureParameters captureParameters) {
        boolean projecting = captureParameters.projection().isPresent();
        PointOfView pov = this.getPointOfView(holder, stack);
        double fov = this.getViewfinderFov((Level)level, stack);
        List<BlockPos> positionsInFrame = !projecting ? this.getPositionsInFrame(holder, pov, fov) : Collections.emptyList();
        List<LivingEntity> entitiesInFrame = !projecting ? EntitiesInFrame.get(holder, pov, fov) : Collections.emptyList();
        Frame frame = this.createFrame(holder, level, stack, captureParameters, positionsInFrame, entitiesInFrame);
        this.addFrameToFilm(stack, frame);
        this.onFrameAdded(holder, level, stack, frame, positionsInFrame, entitiesInFrame);
    }

    public Frame createFrame(CameraHolder holder, ServerLevel level, ItemStack stack, CaptureParameters captureParameters, List<BlockPos> positionsInFrame, List<LivingEntity> entitiesInFrame) {
        return Frame.create().setIdentifier(ExposureIdentifier.id(captureParameters.exposureId())).setType(captureParameters.filmProperties().type()).setPhotographer(new Photographer(holder)).setEntitiesInFrame(entitiesInFrame.stream().limit(10L).map(entity -> EntityInFrame.of(holder.asHolderEntity(), (Entity)entity, data -> PlatformHelper.postModifyEntityInFrameExtraDataEvent(holder, stack, entity, data))).toList()).addExtraData(Frame.SHUTTER_SPEED, CameraSettings.SHUTTER_SPEED.getOrDefault(stack)).addExtraData(Frame.TIMESTAMP, UnixTimestamp.Seconds.now()).updateExtraData(data -> this.addFrameExtraData(holder, level, stack, captureParameters, positionsInFrame, entitiesInFrame, (ExtraData)((Object)data))).toImmutable();
    }

    protected void addFrameExtraData(CameraHolder holder, ServerLevel level, ItemStack camera, CaptureParameters params, List<BlockPos> positionsInFrame, List<LivingEntity> entitiesInFrame, ExtraData data) {
        Entity cameraHolder = holder.asHolderEntity();
        boolean projecting = params.projection().isPresent();
        if (projecting) {
            data.put(Frame.PROJECTED, true);
            return;
        }
        if (params.getFlash()) {
            data.put(Frame.FLASH, true);
        }
        if (this.isInSelfieMode(camera)) {
            data.put(Frame.SELFIE, true);
        }
        if (holder instanceof CameraStandEntity) {
            data.put(Frame.ON_STAND, true);
        }
        double zoom = CameraSettings.ZOOM.getOrDefault(camera).floatValue();
        FocalRange focalRange = this.getFocalRange(level.registryAccess(), camera);
        int focalLength = (int)focalRange.focalLengthFromZoom(zoom);
        data.put(Frame.FOCAL_LENGTH, focalLength);
        params.extraData().get(CaptureParameters.LIGHT_LEVEL).ifPresent(lightLevel -> data.put(Frame.LIGHT_LEVEL, lightLevel));
        if (params.filmProperties().type() == ExposureType.BLACK_AND_WHITE) {
            params.singleChannel().ifPresent(channel -> data.put(Frame.COLOR_CHANNEL, channel));
        }
        data.put(Frame.POSITION, cameraHolder.position());
        data.put(Frame.PITCH, Float.valueOf(cameraHolder.getXRot()));
        data.put(Frame.YAW, Float.valueOf(cameraHolder.getYRot()));
        data.put(Frame.DAY_TIME, (int)level.getDayTime());
        data.put(Frame.DIMENSION, level.dimension().location());
        BlockPos blockPos = cameraHolder.blockPosition();
        int surfaceHeight = level.getHeight(Heightmap.Types.WORLD_SURFACE, cameraHolder.getBlockX(), cameraHolder.getBlockZ());
        level.updateSkyBrightness();
        int skyLight = level.getBrightness(LightLayer.SKY, blockPos);
        if (cameraHolder.isUnderWater()) {
            data.put(Frame.UNDERWATER, true);
        }
        if (cameraHolder.getBlockY() < Math.min(level.getSeaLevel(), surfaceHeight) && skyLight == 0) {
            data.put(Frame.IN_CAVE, true);
        } else if (!cameraHolder.isUnderWater()) {
            Biome.Precipitation precipitation = ((Biome)level.getBiome(blockPos).value()).getPrecipitationAt(blockPos);
            if (level.isThundering() && precipitation != Biome.Precipitation.NONE) {
                data.put(Frame.WEATHER, precipitation == Biome.Precipitation.SNOW ? "Snowstorm" : "Thunder");
            } else if (level.isRaining() && precipitation != Biome.Precipitation.NONE) {
                data.put(Frame.WEATHER, precipitation == Biome.Precipitation.SNOW ? "Snow" : "Rain");
            } else {
                data.put(Frame.WEATHER, "Clear");
            }
        }
        positionsInFrame.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).flatMap(pos -> level.getBiome(pos).unwrapKey().map(ResourceKey::location)).ifPresent(biome -> data.put(Frame.BIOME, biome));
        List structures = positionsInFrame.stream().map(pos -> LevelUtil.getStructuresAt(level, pos)).flatMap(Collection::stream).collect(Collectors.toSet()).stream().toList();
        if (!structures.isEmpty()) {
            data.put(Frame.STRUCTURES, structures);
        }
        PlatformHelper.postModifyFrameExtraDataEvent(holder, camera, params, positionsInFrame, entitiesInFrame, data);
    }

    public List<BlockPos> getPositionsInFrame(CameraHolder cameraHolder, PointOfView pov, double fov) {
        float offsetDegrees = (float)(fov * (double)this.getCropFactor() / 4.3);
        return Vec3Util.getProbeVectors(pov.dir(), offsetDegrees).stream().map(direction -> {
            Vec3 endPos = pov.pos().add(direction.scale(100.0));
            return cameraHolder.asHolderEntity().level().clip(new ClipContext(pov.pos(), endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, cameraHolder.asHolderEntity()));
        }).filter(hit -> hit.getType() != HitResult.Type.MISS).map(BlockHitResult::getBlockPos).toList();
    }

    public void addFrameToFilm(ItemStack stack, Frame frame) {
        Attachment.FILM.ifPresentOrElse(stack, (filmItem, filmStack) -> {
            ItemStack updatedFilmStack = filmStack.copy();
            filmItem.addFrame(updatedFilmStack, frame);
            Attachment.FILM.set(stack, updatedFilmStack);
        }, () -> Exposure.LOGGER.error("Cannot add frame: no film attachment is present."));
    }

    public void onFrameAdded(CameraHolder holder, ServerLevel level, ItemStack stack, Frame frame, List<BlockPos> positionsInFrame, List<LivingEntity> entitiesInFrame) {
        Entity executor = holder.getPlayerExecutingExposure().map(pl -> pl).orElse(holder.asHolderEntity());
        ExposureServer.frameHistory().add(executor, frame);
        entitiesInFrame.forEach(entity -> this.entityCaptured(holder, stack, (LivingEntity)entity));
        holder.getPlayerAwardedForExposure().filter(player -> player instanceof ServerPlayer).ifPresent(player -> {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.awardStat(Exposure.Stats.FILM_FRAMES_EXPOSED);
            Exposure.CriteriaTriggers.FRAME_EXPOSED.get().trigger(serverPlayer, holder, stack, frame, positionsInFrame, entitiesInFrame);
        });
        PlatformHelper.postFrameAddedEvent(holder, stack, frame, positionsInFrame, entitiesInFrame);
    }

    protected void entityCaptured(CameraHolder cameraHolder, ItemStack stack, LivingEntity entity) {
        Entity entity2 = cameraHolder.asHolderEntity();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            if (entity instanceof EnderMan) {
                boolean lookingAtAngryEnderMan;
                EnderMan enderMan = (EnderMan)entity;
                boolean bl = lookingAtAngryEnderMan = player.equals((Object)enderMan.getTarget()) && enderMan.isLookingAtMe((Player)player);
                if (lookingAtAngryEnderMan) {
                    Exposure.CriteriaTriggers.PHOTOGRAPH_ENDERMAN_EYES.get().trigger(player);
                }
            }
        }
    }

    public void handleProjectionResult(ServerLevel level, CameraHolder holder, ItemStack stack, CameraInstance.ProjectionState projectionState, Optional<TranslatableError> error) {
        StoredItemStack filter = Attachment.FILTER.get(stack);
        if (filter.isEmpty()) {
            return;
        }
        Item item = filter.getItem();
        if (!(item instanceof InterplanarProjectorItem)) {
            return;
        }
        InterplanarProjectorItem interplanarProjector = (InterplanarProjectorItem)item;
        if (!interplanarProjector.isConsumable(filter.getForReading())) {
            return;
        }
        Entity entity = holder.asHolderEntity();
        if (projectionState == CameraInstance.ProjectionState.FAILED || projectionState == CameraInstance.ProjectionState.TIMED_OUT) {
            ItemStack filterStack = filter.getCopy().transmuteCopy((ItemLike)Exposure.Items.BROKEN_INTERPLANAR_PROJECTOR.get());
            error.ifPresent(err -> filterStack.set(Exposure.DataComponents.INTERPLANAR_PROJECTOR_ERROR_CODE, (Object)err.code()));
            Attachment.FILTER.set(stack, filterStack);
            Sound.play(entity, Exposure.SoundEvents.BSOD.get());
            if (this.getShutter().isOpen(stack)) {
                this.getShutter().close(holder, level, stack);
            }
            return;
        }
        ItemStack filterStack = filter.getCopy();
        filterStack.shrink(1);
        Attachment.FILTER.set(stack, filterStack);
        if (projectionState == CameraInstance.ProjectionState.SUCCESSFUL) {
            holder.getServerPlayerAwardedForExposure().ifPresent(player -> Exposure.CriteriaTriggers.SUCCESSFULLY_PROJECT_IMAGE.get().trigger(player));
            Sound.play(entity, Exposure.SoundEvents.INTERPLANAR_PROJECT.get(), entity.getSoundSource(), 0.8f, 1.1f);
            for (int i = 0; i < 16; ++i) {
                level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX(), entity.getY() + 1.2, entity.getZ(), 2, entity.getRandom().nextGaussian() * 0.3, entity.getRandom().nextGaussian() * 0.3, entity.getRandom().nextGaussian() * 0.3, 0.01);
            }
        }
    }

    protected int getMatchingSlotInInventory(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!inventory.getItem(i).equals(stack)) continue;
            return i;
        }
        return -1;
    }

    protected void testEntitiesInFrame(ItemStack stack, Level level, CameraHolder holder) {
        PointOfView pov = this.getPointOfView(holder, stack);
        double fov = this.getViewfinderFov(level, stack);
        List<LivingEntity> entities = EntitiesInFrame.get(holder.asHolderEntity(), pov, fov);
        for (LivingEntity livingEntity : entities) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 2, 1, true, false, false));
        }
    }

    protected void testPositionsInFrame(ItemStack stack, Level level, Player player) {
        if (level.isClientSide && level.getGameTime() % 2L == 0L) {
            List<BlockPos> positionsInFrame = this.getPositionsInFrame((CameraHolder)player, this.getPointOfView((CameraHolder)player, stack), this.getViewfinderFov(level, stack));
            for (BlockPos pos : positionsInFrame) {
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.EXPLOSION, true, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public static int getGlassTintColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            BlockItem item;
            CameraItem cameraItem;
            Item item2 = stack.getItem();
            boolean shutterOpen = item2 instanceof CameraItem && (cameraItem = (CameraItem)item2).getShutter().isOpen(stack);
            StoredItemStack filter = Attachment.FILTER.get(stack);
            if (filter.isEmpty()) {
                return shutterOpen ? -13421773 : -1;
            }
            Item item3 = filter.getForReading().getItem();
            if (item3 instanceof BlockItem && (item3 = (item = (BlockItem)item3).getBlock()) instanceof StainedGlassPaneBlock) {
                StainedGlassPaneBlock pane = (StainedGlassPaneBlock)item3;
                return shutterOpen ? Color.argb(pane.getColor().getTextureDiffuseColor()).multiply(0.2f).withAlpha(255).getARGB() : pane.getColor().getTextureDiffuseColor();
            }
            if (filter.getForReading().is((Item)Exposure.Items.INTERPLANAR_PROJECTOR.get())) {
                return shutterOpen ? -16442865 : -11488642;
            }
            if (filter.getForReading().is((Item)Exposure.Items.BROKEN_INTERPLANAR_PROJECTOR.get())) {
                return shutterOpen ? -16761482 : -11227649;
            }
            return -1;
        }
        return -1;
    }
}

