/*
 * Decompiled with CFR 0.152.
 */
package com.farsight.mixin;

import com.farsight.FarsightClientChunkManager;
import com.farsight.FarsightMod;
import com.farsight.config.CommonConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.util.thread.BlockableEventLoop;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPlayNetHandlerMixin
extends ClientCommonPacketListenerImpl {
    @Shadow
    private ClientLevel level;

    protected ClientPlayNetHandlerMixin(Minecraft minecraft, Connection connection, CommonListenerCookie commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Redirect(method={"handleSetChunkCacheRadius"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ClientboundSetChunkCacheRadiusPacket;getRadius()I"))
    private int onViewDistChange(ClientboundSetChunkCacheRadiusPacket sUpdateViewDistancePacket) {
        return ((CommonConfiguration)FarsightMod.config.getCommonConfig()).maxRenderDistance;
    }

    @Redirect(method={"handleLogin"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;chunkRadius()I"))
    private int onJoinGame(ClientboundLoginPacket sJoinGamePacket) {
        return ((CommonConfiguration)FarsightMod.config.getCommonConfig()).maxRenderDistance;
    }

    @Inject(method={"handleForgetLevelChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void onChunkUnload(ClientboundForgetLevelChunkPacket clientboundForgetLevelChunkPacket, CallbackInfo ci) {
        PacketUtils.ensureRunningOnSameThread((Packet)clientboundForgetLevelChunkPacket, (PacketListener)((ClientPacketListener)this), (BlockableEventLoop)this.minecraft);
        ClientChunkCache clientChunkManager = this.level.getChunkSource();
        if (clientChunkManager instanceof FarsightClientChunkManager && ((FarsightClientChunkManager)clientChunkManager).delayUnload(clientboundForgetLevelChunkPacket)) {
            ((FarsightClientChunkManager)clientChunkManager).packetListener = (ClientPacketListener)this;
            ci.cancel();
        }
    }
}

