/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.particles;

import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.util.CustomParticleFunction;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CapsuleParticle
extends FireworkParticles {
    private static final Map<ResourceLocation, CustomParticleFunction> EXPLOSION_MAP = new HashMap<ResourceLocation, CustomParticleFunction>();

    public static void register(ResourceLocation id, CustomParticleFunction consumer) {
        EXPLOSION_MAP.put(id, consumer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Starter
    extends NoRenderParticle {
        private int life = 0;
        private final float rot;
        private final ParticleEngine engine;
        private final List<StickerExplosion> explosions;
        protected final float scale;
        protected final double scaleFactor;

        public Starter(ClientLevel clientLevel, double d, double e, double f, float rot, ParticleEngine particleEngine, List<StickerExplosion> list, float scale) {
            super(clientLevel, d, e, f, 0.0, 0.0, 0.0);
            this.rot = rot;
            this.engine = particleEngine;
            this.scale = scale;
            this.scaleFactor = scale < 1.0f ? 2.0 : (scale < 2.0f ? 1.0 : (scale < 3.0f ? 0.5 : 0.25));
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Cannot create capsule starter with no explosions");
            }
            this.explosions = list;
            this.lifetime = list.size() * 2 - 1;
            if (this.explosions.stream().anyMatch(StickerExplosion::hasTwinkle)) {
                this.lifetime += 15;
            }
        }

        public void tick() {
            if (this.life % 2 == 0 && this.life / 2 < this.explosions.size()) {
                StickerExplosion explosion = this.explosions.get(this.life / 2);
                boolean hasTrail = explosion.hasTrail();
                boolean hasTwinkle = explosion.hasTwinkle();
                IntList colors = explosion.colors();
                IntList fadeColors = explosion.fadeColors();
                if (colors.isEmpty()) {
                    colors = IntList.of((int)DyeColor.BLACK.getFireworkColor());
                }
                if (explosion.id().getNamespace().equals("minecraft")) {
                    switch (explosion.id().getPath()) {
                        case "small_ball": {
                            this.createParticleBall(0.2, 2, colors, fadeColors, hasTrail, hasTwinkle);
                            break;
                        }
                        case "large_ball": {
                            this.createParticleBall(0.25, 3, colors, fadeColors, hasTrail, hasTwinkle);
                            break;
                        }
                        case "star": {
                            this.createParticleShape(0.3, FireworkParticles.Starter.STAR_PARTICLE_COORDS, colors, fadeColors, hasTrail, hasTwinkle, false);
                            break;
                        }
                        case "creeper": {
                            this.createParticleShape(0.3, FireworkParticles.Starter.CREEPER_PARTICLE_COORDS, colors, fadeColors, hasTrail, hasTwinkle, true);
                            break;
                        }
                        case "burst": {
                            this.createParticleBurst(colors, fadeColors, hasTrail, hasTwinkle);
                            break;
                        }
                    }
                } else {
                    CustomParticleFunction explosionParticle = EXPLOSION_MAP.get(explosion.id());
                    if (explosionParticle != null) {
                        explosionParticle.accept(this.level, this.x, this.y, this.z, this.rot, this.engine, explosion, this.scale, this.scaleFactor);
                    }
                }
                int colorValue = colors.getInt(0);
                Particle particle = this.engine.createParticle((ParticleOptions)ParticleTypes.FLASH, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                if (particle != null) {
                    particle.setColor((float)FastColor.ARGB32.red((int)colorValue) / 255.0f, (float)FastColor.ARGB32.green((int)colorValue) / 255.0f, (float)FastColor.ARGB32.blue((int)colorValue) / 255.0f);
                }
            }
            if (++this.life > this.lifetime) {
                this.remove();
            }
        }

        public void createParticle(double d, double e, double f, double g, double h, double i, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) {
            FireworkParticles.SparkParticle sparkParticle = (FireworkParticles.SparkParticle)this.engine.createParticle((ParticleOptions)ParticleTypes.FIREWORK, d, e, f, g, h, i);
            if (sparkParticle == null) {
                return;
            }
            sparkParticle.setTrail(hasTrail);
            sparkParticle.setTwinkle(hasTwinkle);
            sparkParticle.setAlpha(0.99f);
            sparkParticle.setColor(((Integer)Util.getRandom((List)colors, (RandomSource)this.random)).intValue());
            if (!fadeColors.isEmpty()) {
                sparkParticle.setFadeColor(((Integer)Util.getRandom((List)fadeColors, (RandomSource)this.random)).intValue());
            }
        }

        public void createParticleBall(double d, int i, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) {
            d *= (double)this.scale;
            for (double j = (double)(-i); j <= (double)i; j += this.scaleFactor) {
                for (double k = (double)(-i); k <= (double)i; k += this.scaleFactor) {
                    for (double l = (double)(-i); l <= (double)i; l += this.scaleFactor) {
                        double h = k + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double m = j + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double n = l + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double o = Math.sqrt(h * h + m * m + n * n) / d + this.random.nextGaussian() * 0.05;
                        this.createParticle(this.x, this.y, this.z, h / o, m / o, n / o, colors, fadeColors, hasTrail, hasTwinkle);
                        if (j == (double)(-i) || j == (double)i || k == (double)(-i) || k == (double)i) continue;
                        l += (double)(i * 2 - 1);
                    }
                }
            }
        }

        public void createParticleShape(double d, double[][] ds, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle, boolean bl3) {
            double e = ds[0][0];
            double f = ds[0][1];
            this.createParticle(this.x, this.y, this.z, e * (d *= (double)this.scale), f * d, 0.0, colors, fadeColors, hasTrail, hasTwinkle);
            float g = this.random.nextFloat() * (float)Math.PI;
            double h = bl3 ? 0.034 : 0.34;
            for (int i = 0; i < 3; ++i) {
                double j = (double)g + (double)((float)i * (float)Math.PI) * h;
                double k = e;
                double l = f;
                for (int m = 1; m < ds.length; ++m) {
                    double n = ds[m][0];
                    double o = ds[m][1];
                    for (double p = 0.25; p <= 1.0; p += 0.25 * this.scaleFactor) {
                        double q = Mth.lerp((double)p, (double)k, (double)n) * d;
                        double r = Mth.lerp((double)p, (double)l, (double)o) * d;
                        double s = q * Math.sin(j);
                        q *= Math.cos(j);
                        for (double t = -1.0; t <= 1.0; t += 2.0) {
                            this.createParticle(this.x, this.y, this.z, q * t, r, s * t, colors, fadeColors, hasTrail, hasTwinkle);
                        }
                    }
                    k = n;
                    l = o;
                }
            }
        }

        public void createParticleBurst(IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) {
            double d = this.random.nextGaussian() * 0.05;
            double e = this.random.nextGaussian() * 0.05;
            int i = 0;
            while ((double)i < 70.0 / this.scaleFactor) {
                double f = (this.xd * 0.5 + this.random.nextGaussian() * 0.15 + d) * (double)this.scale * 0.5;
                double g = (this.zd * 0.5 + this.random.nextGaussian() * 0.15 + e) * (double)this.scale * 0.5;
                double h = (this.yd * 0.5 + this.random.nextDouble() * 0.5) * (double)this.scale * 0.5;
                this.createParticle(this.x, this.y, this.z, f, h, g, colors, fadeColors, hasTrail, hasTwinkle);
                ++i;
            }
        }
    }
}

