/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.stickers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.TooltipProvider;

public record StickerExplosion(ResourceLocation id, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) implements TooltipProvider
{
    private static final StreamCodec<ByteBuf, IntList> COLOR_LIST_STREAM_CODEC = ByteBufCodecs.INT.apply(ByteBufCodecs.list()).map(IntArrayList::new, ArrayList::new);
    public static final Codec<StickerExplosion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(StickerExplosion::id), (App)FireworkExplosion.COLOR_LIST_CODEC.optionalFieldOf("colors", (Object)IntList.of()).forGetter(StickerExplosion::colors), (App)FireworkExplosion.COLOR_LIST_CODEC.optionalFieldOf("fade_colors", (Object)IntList.of()).forGetter(StickerExplosion::fadeColors), (App)Codec.BOOL.optionalFieldOf("has_trail", (Object)false).forGetter(StickerExplosion::hasTrail), (App)Codec.BOOL.optionalFieldOf("has_twinkle", (Object)false).forGetter(StickerExplosion::hasTwinkle)).apply((Applicative)instance, StickerExplosion::new));
    public static final StreamCodec<ByteBuf, StickerExplosion> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, StickerExplosion::id, COLOR_LIST_STREAM_CODEC, StickerExplosion::colors, COLOR_LIST_STREAM_CODEC, StickerExplosion::fadeColors, (StreamCodec)ByteBufCodecs.BOOL, StickerExplosion::hasTrail, (StreamCodec)ByteBufCodecs.BOOL, StickerExplosion::hasTwinkle, StickerExplosion::new);

    public static StickerExplosion fromFireworks(FireworkExplosion explosion) {
        ResourceLocation id = switch (explosion.shape()) {
            default -> throw new MatchException(null, null);
            case FireworkExplosion.Shape.SMALL_BALL -> ResourceLocation.withDefaultNamespace((String)"small_ball");
            case FireworkExplosion.Shape.LARGE_BALL -> ResourceLocation.withDefaultNamespace((String)"large_ball");
            case FireworkExplosion.Shape.STAR -> ResourceLocation.withDefaultNamespace((String)"star");
            case FireworkExplosion.Shape.CREEPER -> ResourceLocation.withDefaultNamespace((String)"creeper");
            case FireworkExplosion.Shape.BURST -> ResourceLocation.withDefaultNamespace((String)"burst");
        };
        return new StickerExplosion(id, explosion.colors(), explosion.fadeColors(), explosion.hasTrail(), explosion.hasTwinkle());
    }

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        this.addParticleNameTooltip(consumer);
        this.addAdditionalTooltip(consumer);
    }

    public void addParticleNameTooltip(Consumer<Component> consumer) {
        consumer.accept((Component)this.getName().withStyle(ChatFormatting.GRAY));
    }

    public void addAdditionalTooltip(Consumer<Component> consumer) {
        List<DyeColor> dyeColors;
        if (!this.colors.isEmpty() && !(dyeColors = StickerExplosion.getDyeColors(this.colors)).isEmpty()) {
            consumer.accept(StickerExplosion.appendColors(Component.empty().withStyle(ChatFormatting.GRAY), dyeColors));
        }
        if (!this.fadeColors.isEmpty() && !(dyeColors = StickerExplosion.getDyeColors(this.fadeColors)).isEmpty()) {
            consumer.accept(StickerExplosion.appendColors(Component.translatable((String)"item.minecraft.firework_star.fade_to").append(CommonComponents.SPACE).withStyle(ChatFormatting.GRAY), dyeColors));
        }
        if (this.hasTrail) {
            consumer.accept((Component)Component.translatable((String)"item.minecraft.firework_star.trail").withStyle(ChatFormatting.GRAY));
        }
        if (this.hasTwinkle) {
            consumer.accept((Component)Component.translatable((String)"item.minecraft.firework_star.flicker").withStyle(ChatFormatting.GRAY));
        }
    }

    private static List<DyeColor> getDyeColors(IntList colors) {
        ArrayList<DyeColor> dyeColors = new ArrayList<DyeColor>();
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            DyeColor dyeColor = DyeColor.byFireworkColor((int)color);
            if (dyeColor == null) continue;
            dyeColors.add(dyeColor);
        }
        return dyeColors;
    }

    private static Component appendColors(MutableComponent mutableComponent, List<DyeColor> dyeColors) {
        for (int i = 0; i < dyeColors.size(); ++i) {
            if (i > 0) {
                mutableComponent.append(", ");
            }
            mutableComponent.append((Component)Component.translatable((String)("item.minecraft.firework_star." + dyeColors.get(i).getName())));
        }
        return mutableComponent;
    }

    private MutableComponent getName() {
        return Component.translatable((String)String.format("item.%s.sticker.id.%s", this.id().getNamespace(), this.id().getPath()));
    }
}

