/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record CreateObjectMessage(long parent, QuestObjectType questObjectType, boolean openScreen, CompoundTag nbt, Optional<CompoundTag> extra) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CreateObjectMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("create_object_message"));
    public static final StreamCodec<FriendlyByteBuf, CreateObjectMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, CreateObjectMessage::parent, QuestObjectType.STREAM_CODEC, CreateObjectMessage::questObjectType, (StreamCodec)ByteBufCodecs.BOOL, CreateObjectMessage::openScreen, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, CreateObjectMessage::nbt, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.COMPOUND_TAG), CreateObjectMessage::extra, CreateObjectMessage::new);

    public static CreateObjectMessage create(QuestObjectBase questObject, @Nullable CompoundTag extra, boolean openScreen) {
        return new CreateObjectMessage(questObject.getParentID(), questObject.getObjectType(), openScreen, (CompoundTag)Util.make((Object)new CompoundTag(), nbt1 -> questObject.writeData((CompoundTag)nbt1, questObject.getQuestFile().holderLookup())), Optional.ofNullable(extra));
    }

    public static CreateObjectMessage create(QuestObjectBase questObject, @Nullable CompoundTag extra) {
        return CreateObjectMessage.create(questObject, extra, true);
    }

    public CustomPacketPayload.Type<CreateObjectMessage> type() {
        return TYPE;
    }

    public static void handle(CreateObjectMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player patt0$temp;
            if (NetUtils.canEdit(context) && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                CompoundTag extra = message.extra.orElse(new CompoundTag());
                QuestObjectBase object = ServerQuestFile.INSTANCE.create(ServerQuestFile.INSTANCE.newID(), message.questObjectType, message.parent, extra);
                object.readData(message.nbt, (HolderLookup.Provider)context.registryAccess());
                object.onCreated();
                object.getQuestFile().refreshIDMap();
                object.getQuestFile().clearCachedData();
                object.getQuestFile().markDirty();
                object.getQuestFile().getTranslationManager().processInitialTranslation(extra, object);
                NetworkHelper.sendToAll((MinecraftServer)sp.getServer(), (CustomPacketPayload)CreateObjectResponseMessage.create(object, message.extra.orElse(null), message.openScreen ? sp.getUUID() : null));
            }
        });
    }
}

