/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.component;

import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
@ReturnsSelf
public interface AttributeModifierFunctions {
    public ItemAttributeModifiers kjs$getAttributeModifiers();

    default public boolean kjs$hasAttributeModifier(Holder<Attribute> attribute, ResourceLocation id) {
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (!entry.matches(attribute, id)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public AttributeModifier kjs$getAttributeModifier(Holder<Attribute> attribute, ResourceLocation id) {
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (!entry.matches(attribute, id)) continue;
            return entry.modifier();
        }
        return null;
    }

    @HideFromJS
    public void kjs$setAttributeModifiers(ItemAttributeModifiers var1);

    default public void kjs$addAttributeModifier(Holder<Attribute> attribute, AttributeModifier mod, EquipmentSlotGroup slot) {
        this.kjs$setAttributeModifiers(this.kjs$getAttributeModifiers().withModifierAdded(attribute, mod, slot));
    }

    @ApiStatus.NonExtendable
    default public void kjs$setAttributeModifiers(List<ItemAttributeModifiers.Entry> modifiers) {
        this.kjs$setAttributeModifiers(new ItemAttributeModifiers(modifiers, false));
    }

    @ApiStatus.NonExtendable
    default public void kjs$setAttributeModifiersWithTooltip(List<ItemAttributeModifiers.Entry> modifiers) {
        this.kjs$setAttributeModifiers(new ItemAttributeModifiers(modifiers, true));
    }

    @Info(value="Sets the attack speed of this item to the given value, **removing** all other modifiers to attack speed.\nNote that players have a default attack speed of 4.0, so this modifier is added on top of that.\n(Example: Swords have an attack speed of -2.4, leading to a total value of 1.6 without any other changes.)\n")
    default public void kjs$setAttackSpeed(double speed) {
        ItemAttributeModifiers oldMods = this.kjs$getAttributeModifiers();
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>(oldMods.modifiers().size());
        for (ItemAttributeModifiers.Entry entry : oldMods.modifiers()) {
            if (entry.attribute().equals((Object)Attributes.ATTACK_SPEED)) continue;
            list.add(entry);
        }
        list.add(new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        this.kjs$setAttributeModifiers(new ItemAttributeModifiers(list, oldMods.showInTooltip()));
    }

    @Info(value="Sets the attack damage of this item to the given value, **removing** all other modifiers to attack damage.\nNote that since players have a default attack damage of 1.0, total damage will be (dmg + 1.0) before other modifiers.\n(In practice, this simply means that most weapons have this value set to 1 less than what you might think.)\n")
    default public void kjs$setAttackDamage(double dmg) {
        ItemAttributeModifiers oldMods = this.kjs$getAttributeModifiers();
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>(oldMods.modifiers().size());
        for (ItemAttributeModifiers.Entry entry : oldMods.modifiers()) {
            if (entry.attribute().equals((Object)Attributes.ATTACK_DAMAGE)) continue;
            list.add(entry);
        }
        list.add(new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        this.kjs$setAttributeModifiers(new ItemAttributeModifiers(list, oldMods.showInTooltip()));
    }

    default public double kjs$getAttackDamage() {
        double base;
        double sum = base = this.kjs$getBaseAttackDamage();
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (entry.matches(Attributes.ATTACK_DAMAGE, Item.BASE_ATTACK_DAMAGE_ID)) continue;
            AttributeModifier mod = entry.modifier();
            double d1 = mod.amount();
            sum += (switch (mod.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> d1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * base;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * sum;
            });
        }
        return sum;
    }

    default public double kjs$getAttackSpeed() {
        double base;
        double sum = base = this.kjs$getBaseAttackSpeed();
        for (ItemAttributeModifiers.Entry entry : this.kjs$getAttributeModifiers().modifiers()) {
            if (entry.matches(Attributes.ATTACK_SPEED, Item.BASE_ATTACK_SPEED_ID)) continue;
            AttributeModifier mod = entry.modifier();
            double d1 = mod.amount();
            sum += (switch (mod.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> d1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * base;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * sum;
            });
        }
        return sum;
    }

    @Info(value="Overrides the *base* attack speed of this item to be the given value, keeping other modifiers intact.\nNote that players have a default attack speed of 4.0, so this modifier is added on top of that.\n")
    default public void kjs$setBaseAttackSpeed(double speed) {
        this.kjs$addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    @Info(value="Overrides the *base* attack damage of this item to be the given value, keeping other modifiers intact.\nNote that since players have a default attack damage of 1.0, total damage will be (dmg + 1.0) before other modifiers.\n")
    default public void kjs$setBaseAttackDamage(double dmg) {
        this.kjs$addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    default public double kjs$getBaseAttackDamage() {
        for (ItemAttributeModifiers.Entry modifier : this.kjs$getAttributeModifiers().modifiers()) {
            if (!modifier.matches(Attributes.ATTACK_DAMAGE, Item.BASE_ATTACK_DAMAGE_ID)) continue;
            return modifier.modifier().amount();
        }
        return 0.0;
    }

    default public double kjs$getBaseAttackSpeed() {
        for (ItemAttributeModifiers.Entry modifier : this.kjs$getAttributeModifiers().modifiers()) {
            if (!modifier.matches(Attributes.ATTACK_SPEED, Item.BASE_ATTACK_SPEED_ID)) continue;
            return modifier.modifier().amount();
        }
        return 0.0;
    }
}

