/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class KubeJSBackgroundThread
extends Thread {
    public static boolean running = true;

    public KubeJSBackgroundThread() {
        super("kubejs-background-thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(KubeJSBackgroundThread::shutdown, "kubejs-background-thread-shutdown"));
        for (ScriptType type : ScriptType.VALUES) {
            type.executor = Executors.newSingleThreadExecutor(Thread.ofVirtual().name("kubejs-" + String.valueOf(type) + "-background-task-").factory());
        }
        while (running) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (ScriptType type : ScriptType.VALUES) {
                type.console.flush(false);
            }
        }
        for (ScriptType type : ScriptType.VALUES) {
            boolean b;
            type.console.flush(true);
            Executor executor = type.executor;
            if (!(executor instanceof ExecutorService)) continue;
            ExecutorService service = (ExecutorService)executor;
            service.shutdown();
            try {
                b = service.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException var3) {
                b = false;
            }
            if (b) continue;
            service.shutdownNow();
        }
    }

    public static void shutdown() {
        running = false;
        for (ScriptType value : ScriptType.VALUES) {
            value.console.flush(true);
        }
    }
}

