/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block.custom;

import com.github.yajatkaul.mega_showdown.block.custom.CrystalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ParticleBlock
extends CrystalBlock {
    public final VoxelShape SHAPE;
    public final ParticleOptions particleType;

    public ParticleBlock(float f, float g, BlockBehaviour.Properties arg, boolean dropExp, VoxelShape shape, ParticleOptions particleType) {
        super(f, g, arg, dropExp);
        this.SHAPE = shape;
        this.particleType = particleType;
    }

    @NotNull
    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.SHAPE;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        double x = (double)blockPos.getX() + 0.5;
        double y = (double)blockPos.getY() + 0.5;
        double z = (double)blockPos.getZ() + 0.5;
        for (int i = 0; i < 3; ++i) {
            double offsetX = (randomSource.nextDouble() - 0.5) * 0.5;
            double offsetY = (randomSource.nextDouble() - 0.5) * 0.5;
            double offsetZ = (randomSource.nextDouble() - 0.5) * 0.5;
            level.addParticle(this.particleType, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

