/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.mixin.client;

import com.github.yajatkaul.mega_showdown.codec.item.ItemRenderingCodec;
import com.github.yajatkaul.mega_showdown.codec.item.PerspectivesCodec;
import com.github.yajatkaul.mega_showdown.render.ItemRenderingLoader;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Shadow
    @Final
    private ItemModelShaper itemModelShaper;

    @Shadow
    public abstract ItemModelShaper getItemModelShaper();

    @ModifyVariable(method={"render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at=@At(value="HEAD"), argsOnly=true)
    public BakedModel modifyModel(BakedModel bakedModel, @Local(argsOnly=true) ItemStack stack, @Local(argsOnly=true) ItemDisplayContext renderMode) {
        for (ItemRenderingCodec itemRender : ItemRenderingLoader.REGISTRY) {
            Item item = (Item)BuiltInRegistries.ITEM.get(itemRender.itemId());
            PerspectivesCodec perspectives = itemRender.perspectivesCodec();
            if (stack.getItem() != item) continue;
            if (renderMode == ItemDisplayContext.GUI) {
                return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.guiLoc().get()));
            }
            if (renderMode == ItemDisplayContext.HEAD) {
                return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.headLoc().get()));
            }
            if (renderMode == ItemDisplayContext.GROUND) {
                return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.groundLoc().get()));
            }
            if (renderMode == ItemDisplayContext.FIXED) {
                return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.fixedLoc().get()));
            }
            if (renderMode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.hand().get()));
            }
            if (renderMode == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.hand().get()));
            }
            if (renderMode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.hand3rd().get()));
            }
            if (renderMode != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) continue;
            return this.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)perspectives.hand3rd().get()));
        }
        return bakedModel;
    }

    @ModifyVariable(method={"getModel(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)Lnet/minecraft/client/resources/model/BakedModel;"}, at=@At(value="STORE"), ordinal=1)
    public BakedModel getHeldItemModelMixin(BakedModel bakedModel, @Local(argsOnly=true) ItemStack stack) {
        for (ItemRenderingCodec itemRender : ItemRenderingLoader.REGISTRY) {
            Item item = (Item)BuiltInRegistries.ITEM.get(itemRender.itemId());
            if (stack.getItem() != item) continue;
            return this.itemModelShaper.getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)itemRender.itemId_3d()));
        }
        return bakedModel;
    }
}

