/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.misc.SlotProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface InvPlacer {
    public static final SimplePlacer EXISTING = InvPlacer.of(SlotProvider.ALL, stack -> !stack.isEmpty());
    public static final SimplePlacer EMPTY = InvPlacer.of(SlotProvider.ALL, ItemStack::isEmpty);
    public static final SimplePlacer ANY = InvPlacer.of(SlotProvider.ALL);
    public static final InvPlacer DEFAULT = EXISTING.or(ANY);
    public static final InvPlacer DROP = (stack, inventory, player) -> {
        player.drop(stack, false);
        return true;
    };

    public boolean place(ItemStack var1, Inventory var2, Player var3);

    default public InvPlacer or(InvPlacer other) {
        return (stack, inventory, player) -> this.place(stack, inventory, player) || other.place(stack, inventory, player);
    }

    public static ExclusivePlacer exclusiveSequence() {
        return new ExclusivePlacer();
    }

    public static SimplePlacer of(SlotProvider slots) {
        return InvPlacer.of(slots, (Predicate<ItemStack>)Predicates.alwaysTrue());
    }

    public static SimplePlacer of(SlotProvider slots, Predicate<ItemStack> predicate) {
        return new SimplePlacer(slots, predicate);
    }

    public static InvPlacer handOrExistingOrAnyAvoidEmptyHand(InteractionHand hand) {
        return InvPlacer.exclusiveSequence().stage(InvPlacer.handNotEmpty(hand)).stage(EXISTING).stage(ANY).or(ANY);
    }

    public static InvPlacer handOrExistingOrAny(InteractionHand hand) {
        return InvPlacer.hand(hand).or(EXISTING).or(ANY);
    }

    public static InvPlacer existingOrAny() {
        return DEFAULT;
    }

    public static SimplePlacer handNotEmpty(InteractionHand hand) {
        return InvPlacer.hand(hand, stack -> !stack.isEmpty());
    }

    public static SimplePlacer hand(InteractionHand hand) {
        return InvPlacer.hand(hand, (Predicate<ItemStack>)Predicates.alwaysTrue());
    }

    public static SimplePlacer hand(InteractionHand hand, Predicate<ItemStack> predicate) {
        return InvPlacer.of(SlotProvider.hand(hand), predicate);
    }

    public static SimplePlacer slot(int slot) {
        return InvPlacer.of(SlotProvider.single(slot));
    }

    public static class ExclusivePlacer
    implements InvPlacer {
        private final List<Stage> stages = new ArrayList<Stage>();
        private final Set<SlotProvider.Slot> visitedSlots = new HashSet<SlotProvider.Slot>();

        public ExclusivePlacer stage(SlotProvider provider, Predicate<ItemStack> predicate) {
            this.stage(InvPlacer.of(provider, predicate));
            return this;
        }

        public ExclusivePlacer stage(SlotProvider provider) {
            return this.stage(provider, (Predicate<ItemStack>)Predicates.alwaysTrue());
        }

        public ExclusivePlacer stage(Stage stage) {
            this.stages.add(stage);
            return this;
        }

        @Override
        public boolean place(ItemStack stack, Inventory inventory, Player player) {
            for (Stage stage : this.stages) {
                Iterator<SlotProvider.Slot> slots = stage.slotProvider().getSlots(inventory);
                while (slots.hasNext()) {
                    Predicate<ItemStack> predicate;
                    SlotProvider.Slot slot = slots.next();
                    if (this.visitedSlots.contains(slot) || !(predicate = stage.predicate()).test(slot.getStack())) continue;
                    this.visitedSlots.add(slot);
                    if (slot.add(stack, inventory, player)) {
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }

        static interface Stage {
            public SlotProvider slotProvider();

            public Predicate<ItemStack> predicate();
        }
    }

    public record SimplePlacer(SlotProvider slotProvider, Predicate<ItemStack> predicate) implements InvPlacer,
    ExclusivePlacer.Stage
    {
        @Override
        public boolean place(ItemStack stack, Inventory inventory, Player player) {
            Iterator<SlotProvider.Slot> iterator = this.slotProvider.getSlots(inventory);
            while (iterator.hasNext()) {
                SlotProvider.Slot slot = iterator.next();
                if (!this.predicate.test(slot.getStack()) || !slot.add(stack, inventory, player)) continue;
                return true;
            }
            return false;
        }
    }
}

