/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.nyfaria.nyfsspiders.network.UpdateMovementTargetY;
import com.nyfaria.nyfsspiders.network.UpdateMovementTargetZ;
import com.nyfaria.nyfsspiders.network.UpdatePathingSide;
import com.nyfaria.nyfsspiders.network.UpdatePathingTarget;
import com.nyfaria.nyfsspiders.network.UpdateRotationBody;
import com.nyfaria.nyfsspiders.network.UpdateRotationHead;
import com.nyfaria.nyfsspiders.platform.Services;
import commonnetwork.api.Network;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.monster.Spider;
import org.joml.Vector3f;

public class SpiderData {
    public static Codec<SpiderData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("movementTargetX").forGetter(SpiderData::getMovementTargetX), (App)Codec.FLOAT.fieldOf("movementTargetY").forGetter(SpiderData::getMovementTargetY), (App)Codec.FLOAT.fieldOf("movementTargetZ").forGetter(SpiderData::getMovementTargetZ), (App)ExtraCodecs.VECTOR3F.fieldOf("rotationBody").forGetter(SpiderData::getRotationBody), (App)ExtraCodecs.VECTOR3F.fieldOf("rotationHead").forGetter(SpiderData::getRotationHead), (App)Codec.list((Codec)Direction.CODEC).fieldOf("pathingSides").forGetter(SpiderData::getPathingSides), (App)Codec.list((Codec)BlockPos.CODEC).xmap(list -> {
        ArrayList newList = new ArrayList();
        for (BlockPos pos : list) {
            if (pos == BlockPos.ZERO) {
                newList.add(Optional.empty());
                continue;
            }
            newList.add(Optional.ofNullable(pos));
        }
        return newList;
    }, list -> list.stream().map(pos -> pos.orElse(BlockPos.ZERO)).toList()).fieldOf("pathingTargets").forGetter(SpiderData::getPathingTargets)).apply((Applicative)instance, SpiderData::new));
    private float movementTargetX = 0.0f;
    private float movementTargetY = 0.0f;
    private float movementTargetZ = 0.0f;
    private Vector3f rotationBody = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f rotationHead = new Vector3f(0.0f, 0.0f, 0.0f);
    private List<Direction> pathingSides = List.of(Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN);
    private List<Optional<BlockPos>> pathingTargets = List.of(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private Spider spider;

    public SpiderData(Spider spider) {
        this.spider = spider;
    }

    public SpiderData() {
    }

    public SpiderData(float movementTargetX, float movementTargetY, float movementTargetZ, Vector3f rotationBody, Vector3f rotationHead, List<Direction> pathingSides, List<Optional<BlockPos>> pathingTargets) {
        this.movementTargetX = movementTargetX;
        this.movementTargetY = movementTargetY;
        this.movementTargetZ = movementTargetZ;
        this.rotationBody = rotationBody;
        this.rotationHead = rotationHead;
        this.pathingSides = pathingSides;
        this.pathingTargets = pathingTargets;
    }

    public float getMovementTargetX() {
        return this.movementTargetX;
    }

    public void setMovementTargetX(float movementTargetX) {
        this.movementTargetX = movementTargetX;
        if (this.spider.getServer() != null) {
            Services.PLATFORM.setSpiderData(this.spider, this);
            Network.getNetworkHandler().sendToAllClients((Object)new UpdateRotationBody(this.spider.getId(), this.rotationBody), this.spider.getServer());
        }
    }

    public float getMovementTargetY() {
        return this.movementTargetY;
    }

    public void setMovementTargetY(float movementTargetY) {
        this.movementTargetY = movementTargetY;
        if (this.spider.getServer() != null) {
            Services.PLATFORM.setSpiderData(this.spider, this);
            Network.getNetworkHandler().sendToAllClients((Object)new UpdateMovementTargetY(this.spider.getId(), movementTargetY), this.spider.getServer());
        }
    }

    public float getMovementTargetZ() {
        return this.movementTargetZ;
    }

    public void setMovementTargetZ(float movementTargetZ) {
        this.movementTargetZ = movementTargetZ;
        if (this.spider.getServer() != null) {
            Services.PLATFORM.setSpiderData(this.spider, this);
            Network.getNetworkHandler().sendToAllClients((Object)new UpdateMovementTargetZ(this.spider.getId(), movementTargetZ), this.spider.getServer());
        }
    }

    public Vector3f getRotationBody() {
        return this.rotationBody;
    }

    public void setRotationBody(Vector3f rotationBody) {
        this.rotationBody = rotationBody;
        if (this.spider.getServer() != null) {
            Services.PLATFORM.setSpiderData(this.spider, this);
            Network.getNetworkHandler().sendToAllClients((Object)new UpdateRotationBody(this.spider.getId(), rotationBody), this.spider.getServer());
        }
    }

    public Vector3f getRotationHead() {
        return this.rotationHead;
    }

    public void setRotationHead(Vector3f rotationHead) {
        this.rotationHead = rotationHead;
        if (this.spider.getServer() != null) {
            Services.PLATFORM.setSpiderData(this.spider, this);
            Network.getNetworkHandler().sendToAllClients((Object)new UpdateRotationHead(this.spider.getId(), rotationHead), this.spider.getServer());
        }
    }

    public List<Direction> getPathingSides() {
        return this.pathingSides;
    }

    public void setPathingSides(List<Direction> pathingSides) {
        this.pathingSides = pathingSides;
    }

    public List<Optional<BlockPos>> getPathingTargets() {
        return this.pathingTargets;
    }

    public void setPathingTargets(List<Optional<BlockPos>> pathingTargets) {
        this.pathingTargets = pathingTargets;
    }

    public void setPathingTarget(int index, BlockPos pos) {
        this.pathingTargets.set(index, Optional.ofNullable(pos));
        if (this.spider.getServer() != null) {
            Services.PLATFORM.setSpiderData(this.spider, this);
            Network.getNetworkHandler().sendToAllClients((Object)new UpdatePathingTarget(this.spider.getId(), index, pos), this.spider.getServer());
        }
    }

    public void setPathingSide(int index, Direction side) {
        this.pathingSides.set(index, side);
        if (this.spider.getServer() != null) {
            Services.PLATFORM.setSpiderData(this.spider, this);
            Network.getNetworkHandler().sendToAllClients((Object)new UpdatePathingSide(this.spider.getId(), index, side), this.spider.getServer());
        }
    }

    public Spider getSpider() {
        return this.spider;
    }

    public void setSpider(Spider spider) {
        this.spider = spider;
    }
}

