/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumleafculling;

import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import toni.sodiumleafculling.LeafCullingQuality;
import toni.sodiumleafculling.PerformanceSettingsAccessor;

public class LeafCulling {
    private static final Direction[] VALUES = Direction.values();

    public static boolean isFacingAir(BlockGetter view, BlockPos pos, Direction facing) {
        Vec3i vec = facing.getNormal();
        return view.getBlockState(pos.offset(vec)).getBlock() instanceof AirBlock;
    }

    public static boolean surroundedByLeaves(BlockGetter view, BlockPos pos) {
        boolean isAggressiveMode = ((PerformanceSettingsAccessor)SodiumClientMod.options().performance).sodiumleafculling$getQuality() == LeafCullingQuality.SOLID_AGGRESSIVE;
        for (Direction dir : VALUES) {
            BlockPos dirPos;
            BlockState blockstate;
            if (isAggressiveMode && (dir == Direction.DOWN || dir == Direction.UP) || (blockstate = view.getBlockState(dirPos = pos.offset(dir.getNormal()))).getBlock() instanceof LeavesBlock || blockstate.isSolidRender(view, pos)) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldCullSide(BlockGetter view, BlockPos pos, Direction facing, int depth) {
        if (LeafCulling.isFacingAir(view, pos, facing)) {
            return false;
        }
        Vec3i vec = facing.getNormal();
        boolean cull = true;
        for (int i = 1; i <= depth; ++i) {
            BlockState state = view.getBlockState(pos.offset(vec.multiply(i)));
            cull &= state != null && state.getBlock() instanceof LeavesBlock;
        }
        return cull;
    }
}

