/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.config;

import hexagonnico.undergroundworlds.config.ConfigValueMap;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public abstract class ModConfig {
    public static final Supplier<Boolean> GENERATE_UNDERGROUND_JUNGLE;
    public static final Supplier<Boolean> GENERATE_JUNGLE_TEMPLE;
    public static final Supplier<Boolean> GENERATE_JUNGLE_CHESTS;
    public static final Supplier<Boolean> TEMPLE_TOOLS_FOUND_IN_TEMPLE;
    public static final Supplier<Boolean> TEMPLE_TOOLS_BLAST_PROOF;
    public static final Supplier<Double> BLADE_OF_THE_JUNGLE_POISON_CHANCE;
    public static final Supplier<Integer> BLADE_OF_THE_JUNGLE_POISON_TIME;
    public static final Supplier<Boolean> AXE_OF_REGROWTH_PLANTS_SAPLINGS;
    public static final Supplier<Boolean> ANTIDOTE_FLASK_FOUND_IN_CHESTS;
    public static final Supplier<Boolean> ANTIDOTE_FLASK_FOUND_IN_TEMPLE;
    public static final Supplier<Integer> ANTIDOTE_FLASK_DURABILITY_DAMAGE;
    public static final Supplier<Double> JUNGLE_ZOMBIE_POISON_CHANCE;
    public static final Supplier<Integer> JUNGLE_ZOMBIE_POISON_TIME;
    public static final Supplier<Double> JUNGLE_BEE_POISON_CHANCE_EASY;
    public static final Supplier<Double> JUNGLE_BEE_POISON_CHANCE_NORMAL;
    public static final Supplier<Double> JUNGLE_BEE_POISON_CHANCE_HARD;
    public static final Supplier<Integer> JUNGLE_BEE_POISON_TIME_EASY;
    public static final Supplier<Integer> JUNGLE_BEE_POISON_TIME_NORMAL;
    public static final Supplier<Integer> JUNGLE_BEE_POISON_TIME_HARD;
    public static final Supplier<Boolean> GENERATE_SPIDER_CAVE;
    public static final Supplier<Boolean> GENERATE_WEB_COVERED_CHESTS;
    public static final Supplier<Boolean> GENERATE_SPIDER_HOUSE;
    public static final Supplier<Integer> BLACK_RECLUSE_POISON_TIME_EASY;
    public static final Supplier<Integer> BLACK_RECLUSE_POISON_TIME_NORMAL;
    public static final Supplier<Integer> BLACK_RECLUSE_POISON_TIME_HARD;
    public static final Supplier<Double> SPIDER_ARMOR_POISON_CHANCE;
    public static final Supplier<Integer> SPIDER_ARMOR_POISON_TIME;
    public static final Supplier<Boolean> GENERATE_UNDERGROUND_TUNDRA;
    public static final Supplier<Boolean> GENERATE_ICE_DUNGEON;
    public static final Supplier<Boolean> FROZEN_CORE_FOUND_IN_ICE_DUNGEON;
    public static final Supplier<Integer> FREEZING_TOOLS_FREEZE_TIME;
    public static final Supplier<Integer> FREEZING_TOOLS_MAX_FREEZE_TIME;
    public static final Supplier<Integer> FROZEN_ZOMBIE_FREEZE_TIME;
    public static final Supplier<Integer> FROZEN_ZOMBIE_MAX_FREEZE_TIME;
    public static final Supplier<Boolean> ICY_CREEPER_CAN_FREEZE;
    public static final Supplier<Boolean> GENERATE_UNDERGROUND_DESERT;
    public static final Supplier<Boolean> GENERATE_PYRAMID;
    public static final Supplier<Boolean> DESERT_CHARM_FOUND_IN_PYRAMID;
    public static final Supplier<Integer> DESERT_CHARM_DURABILITY_DAMAGE;
    public static final Supplier<Integer> ASHAN_BLINDNESS_TIME;
    public static final Supplier<Integer> WRAPPED_BLINDNESS_TIME;
    public static final Supplier<Boolean> GENERATE_CHILLAGER_OUTPOST;
    public static final Supplier<Boolean> GENERATE_JUNGLE_TREEHOUSE;
    public static final Supplier<Boolean> GENERATE_SWAMP_HOUSE;
    public static final ConfigValueMap CONFIG;

    public abstract ModConfig push(String var1);

    public abstract ModConfig comment(String var1);

    public abstract Supplier<Boolean> define(String var1, boolean var2);

    public abstract Supplier<Integer> define(String var1, int var2, int var3, int var4);

    public abstract Supplier<Double> define(String var1, double var2, double var4, double var6);

    public abstract ModConfig pop();

    public abstract ConfigValueMap build();

    static {
        ModConfig config = ServiceLoader.load(ModConfig.class).findFirst().orElseThrow();
        config.push("underground_jungle");
        config.comment("Whether the underground jungle should generate in the world");
        GENERATE_UNDERGROUND_JUNGLE = config.define("generate_biome", true);
        config.comment("Whether the jungle temple should generate in the underground jungle");
        GENERATE_JUNGLE_TEMPLE = config.define("generate_temple", true);
        config.comment("Whether chests should generate around in the underground jungle");
        GENERATE_JUNGLE_CHESTS = config.define("generate_chests", true);
        config.push("temple_tools");
        config.comment("Whether temple tools should be found in the jungle temple");
        TEMPLE_TOOLS_FOUND_IN_TEMPLE = config.define("found_in_temple", true);
        config.comment("Whether temple tools are immune to explosion damage");
        TEMPLE_TOOLS_BLAST_PROOF = config.define("blast_proof", true);
        config.pop().push("blade_of_the_jungle");
        config.comment("Chance to inflict poison with the Blade of the Jungle");
        BLADE_OF_THE_JUNGLE_POISON_CHANCE = config.define("poison_chance", 0.2, 0.0, 1.0);
        config.comment("Duration of the poison effect inflicted with the Blade of the Jungle in seconds");
        BLADE_OF_THE_JUNGLE_POISON_TIME = config.define("poison_time", 10, 1, Integer.MAX_VALUE);
        config.pop().push("axe_of_regrowth");
        config.comment("Whether the axe of regrowth can plant saplings");
        config.comment("Set this to false if it's causing issues with other mods");
        AXE_OF_REGROWTH_PLANTS_SAPLINGS = config.define("plants_saplings", true);
        config.pop().push("jungle_zombie");
        config.comment("Chance the jungle zombie has to inflict poison");
        JUNGLE_ZOMBIE_POISON_CHANCE = config.define("poison_chance", 0.2, 0.0, 1.0);
        config.comment("Duration of the poison effect inflicted by the jungle zombie in seconds");
        JUNGLE_ZOMBIE_POISON_TIME = config.define("poison_time", 3, 1, Integer.MAX_VALUE);
        config.pop().push("jungle_bee");
        config.comment("Chance the jungle bee has to inflict poison in easy difficulty");
        JUNGLE_BEE_POISON_CHANCE_EASY = config.define("poison_chance_easy", 0.0, 0.0, 1.0);
        config.comment("Chance the jungle bee has to inflict poison in normal difficulty");
        JUNGLE_BEE_POISON_CHANCE_NORMAL = config.define("poison_chance_normal", 1.0, 0.0, 1.0);
        config.comment("Chance the jungle bee has to inflict poison in hard difficulty");
        JUNGLE_BEE_POISON_CHANCE_HARD = config.define("poison_chance_hard", 1.0, 0.0, 1.0);
        config.comment("Duration of the poison effect inflicted by the jungle bee in seconds on easy difficulty");
        JUNGLE_BEE_POISON_TIME_EASY = config.define("poison_time_easy", 5, 1, Integer.MAX_VALUE);
        config.comment("Duration of the poison effect inflicted by the jungle bee in seconds on normal difficulty");
        JUNGLE_BEE_POISON_TIME_NORMAL = config.define("poison_time_normal", 10, 1, Integer.MAX_VALUE);
        config.comment("Duration of the poison effect inflicted by the jungle bee in seconds on hard difficulty");
        JUNGLE_BEE_POISON_TIME_HARD = config.define("poison_time_hard", 20, 1, Integer.MAX_VALUE);
        config.pop().push("antidote_flask");
        config.comment("Whether the antidote flask should be found in chests in the underground jungle");
        ANTIDOTE_FLASK_FOUND_IN_CHESTS = config.define("found_in_chests", true);
        config.comment("Whether the antidote flask should be found in chests in the jungle temple");
        ANTIDOTE_FLASK_FOUND_IN_TEMPLE = config.define("found_in_temple", false);
        config.comment("How much durability to take from the antidote flask every time it blocks the poison effect");
        config.comment("Can be set to a number higher than 1 to effectively decrease the durability of the antidote flask");
        ANTIDOTE_FLASK_DURABILITY_DAMAGE = config.define("durability_damage", 1, 1, Integer.MAX_VALUE);
        config.pop().pop().push("spider_caves");
        config.comment("Whether the spider cave should generate in the world");
        GENERATE_SPIDER_CAVE = config.define("generate_biome", true);
        config.comment("Whether chests should generate around in the spider caves");
        GENERATE_WEB_COVERED_CHESTS = config.define("generate_chests", true);
        config.comment("Whether abandoned houses should generate around in the spider caves");
        GENERATE_SPIDER_HOUSE = config.define("generate_houses", true);
        config.push("black_recluse");
        config.comment("Duration of the poison effect inflicted by the black recluse on easy difficulty");
        BLACK_RECLUSE_POISON_TIME_EASY = config.define("poison_time_easy", 5, 0, Integer.MAX_VALUE);
        config.comment("Duration of the poison effect inflicted by the black recluse on normal difficulty");
        BLACK_RECLUSE_POISON_TIME_NORMAL = config.define("poison_time_normal", 10, 0, Integer.MAX_VALUE);
        config.comment("Duration of the poison effect inflicted by the black recluse on hard difficulty");
        BLACK_RECLUSE_POISON_TIME_HARD = config.define("poison_time_hard", 20, 0, Integer.MAX_VALUE);
        config.pop().push("spider_armor");
        config.comment("Chance the spider armor has to poison attackers");
        SPIDER_ARMOR_POISON_CHANCE = config.define("poison_chance", 0.1, 0.0, 1.0);
        config.comment("Duration of the poison effect inflicted by the spider armor in seconds");
        SPIDER_ARMOR_POISON_TIME = config.define("poison_time", 10, 1, Integer.MAX_VALUE);
        config.pop().pop().push("underground_tundra");
        config.comment("Whether the underground tundra should generate in the world");
        GENERATE_UNDERGROUND_TUNDRA = config.define("generate_biome", true);
        config.comment("Whether the ice dungeon should generate in the underground tundra");
        GENERATE_ICE_DUNGEON = config.define("generate_ice_dungeon", true);
        config.push("frozen_core");
        config.comment("Whether the frozen core should be found in chests in the ice dungeon");
        FROZEN_CORE_FOUND_IN_ICE_DUNGEON = config.define("found_in_ice_dungeon", true);
        config.pop().push("freezing_tools");
        config.comment("Duration of the freezing effect inflicted by freezing tools in seconds");
        FREEZING_TOOLS_FREEZE_TIME = config.define("freezing_time", 5, 0, Integer.MAX_VALUE);
        config.comment("Maximum duration of the freezing effect that can be inflicted by freezing tools in seconds");
        FREEZING_TOOLS_MAX_FREEZE_TIME = config.define("freezing_max_time", 20, 1, Integer.MAX_VALUE);
        config.pop().push("frozen_zombie");
        config.comment("Duration of the freezing effect inflicted by the frozen zombie in seconds");
        FROZEN_ZOMBIE_FREEZE_TIME = config.define("freezing_time", 5, 0, Integer.MAX_VALUE);
        config.comment("Maximum duration of the freezing effect that can be inflicted by the frozen zombie in seconds");
        FROZEN_ZOMBIE_MAX_FREEZE_TIME = config.define("freezing_max_time", 20, 1, Integer.MAX_VALUE);
        config.pop().push("icy_creeper");
        config.comment("Whether the icy creeper should be able to freeze entities hit by its explosion");
        ICY_CREEPER_CAN_FREEZE = config.define("can_freeze", true);
        config.pop().pop().push("underground_desert");
        config.comment("Whether the underground desert should generate in the world");
        GENERATE_UNDERGROUND_DESERT = config.define("generate_biome", true);
        config.comment("Whether the pyramid should generate in the underground desert");
        GENERATE_PYRAMID = config.define("generate_pyramid", true);
        config.push("desert_charm");
        config.comment("Whether the desert charm should be found in the pyramid");
        DESERT_CHARM_FOUND_IN_PYRAMID = config.define("found_in_pyramid", true);
        config.comment("How much durability to take from the desert charm every time it blocks the blindness effect");
        config.comment("Can be set to a number higher than 1 to effectively decrease the durability of the desert charm");
        DESERT_CHARM_DURABILITY_DAMAGE = config.define("durability_damage", 1, 1, Integer.MAX_VALUE);
        config.pop().push("ashan");
        config.comment("Duration of the blindness effect inflicted by the ashan in seconds");
        ASHAN_BLINDNESS_TIME = config.define("blindness_time", 5, 0, Integer.MAX_VALUE);
        config.pop().push("wrapped");
        config.comment("Duration of the blindness effect inflicted by the wrapped in seconds");
        WRAPPED_BLINDNESS_TIME = config.define("blindness_time", 5, 0, Integer.MAX_VALUE);
        config.pop().pop().push("chillager_outpost");
        config.comment("Whether the chillager outpost should generate in snowy biomes");
        GENERATE_CHILLAGER_OUTPOST = config.define("generate_chillager_outpost", true);
        config.pop().push("jungle_treehouse");
        config.comment("Whether the jungle treehouse should generate in jungle biomes");
        GENERATE_JUNGLE_TREEHOUSE = config.define("generate_jungle_treehouse", true);
        config.pop().push("swamp_house");
        config.comment("Whether the swamp house should generate in swamps");
        GENERATE_SWAMP_HOUSE = config.define("generate_swamp_house", true);
        CONFIG = config.build();
    }
}

