/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.support;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import dev.tr7zw.transition.mc.MathUtil;
import dev.tr7zw.waveycapes.support.AnimationSupport;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class PlayerAnimatorSupport
implements AnimationSupport {
    @Override
    public Vector3 applyAnimationChanges(AbstractClientPlayer entity, float delta, Vector3 cur) {
        IAnimatedPlayer player;
        if (entity instanceof IAnimatedPlayer && (player = (IAnimatedPlayer)entity).playerAnimator_getAnimation().isActive()) {
            CapeHolder capeHolder = (CapeHolder)entity;
            AnimationApplier anim = player.playerAnimator_getAnimation();
            anim.setTickDelta(delta);
            Vec3f rot = anim.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
            Vec3f pos = anim.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
            Vec3f headPos = anim.get3DTransform("head", TransformType.POSITION, Vec3f.ZERO).scale(0.0625f);
            Matrix4f relativeTranslation = new Matrix4f();
            relativeTranslation.identity();
            relativeTranslation.scale(-1.0f);
            float bodyOffset = 0.8f;
            relativeTranslation.translate(0.0f, -0.8f, 0.0f);
            relativeTranslation.translate(((Float)pos.getX()).floatValue(), ((Float)pos.getY()).floatValue(), ((Float)pos.getZ()).floatValue());
            relativeTranslation.rotate((Quaternionfc)MathUtil.ZP.rotation(((Float)rot.getZ()).floatValue()));
            relativeTranslation.rotate((Quaternionfc)MathUtil.YP.rotation(((Float)rot.getY()).floatValue()));
            relativeTranslation.rotate((Quaternionfc)MathUtil.XP.rotation(((Float)rot.getX()).floatValue()));
            relativeTranslation.translate(-((Float)headPos.getX()).floatValue(), -((Float)headPos.getY()).floatValue(), ((Float)headPos.getZ()).floatValue());
            relativeTranslation.translate(0.0f, 0.8f, 0.0f);
            float realYaw = Mth.rotLerp((float)delta, (float)entity.yBodyRotO, (float)entity.yBodyRot);
            Matrix4f matrix = new Matrix4f();
            matrix.mul((Matrix4fc)new Matrix4f().scale(-1.0f, 1.0f, 1.0f));
            matrix.mul((Matrix4fc)new Matrix4f().rotate((Quaternionfc)MathUtil.YP.rotationDegrees(realYaw)));
            matrix.mul((Matrix4fc)new Matrix4f().scale(1.0f, 1.0f, -1.0f));
            matrix.mul((Matrix4fc)relativeTranslation);
            Vector4f offset = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            offset.mul((Matrix4fc)matrix);
            float scale = -16.0f;
            Vector3 curOffset = new Vector3(offset.x() * scale, offset.y() * scale, offset.z() + scale);
            Vector3 lastOffset = capeHolder.getLastPlayerAnimatorPosition();
            capeHolder.setLastPlayerAnimatorPosition(curOffset.clone());
            curOffset.subtract(lastOffset);
            cur.add(curOffset);
        }
        return cur;
    }
}

