{
  name: "Aftertaste",
  rating: 3,
  onAfterMove(source, target, move) {
    if (!target || !move || move.category === "Status") return;
    if (target.fainted) return;
    if (source.species.id !== 'spirikatomb') return;

    const ghostImmunity = this.dex.getImmunity('Ghost', target);
    if (!ghostImmunity) {
      this.add('-ability', source, 'Aftertaste');
      this.add(`-${target.name} is unaffected by Aftertaste!`);
      return;
    }

    let hpToLose = Math.floor(target.maxhp * 0.15);

    const effectiveness = this.dex.getEffectiveness('Ghost', target.getTypes());

    if (effectiveness > 0) {
      hpToLose *= 2;
    } else if (effectiveness < 0) {
      hpToLose = Math.floor(hpToLose / 2);
    }

    this.damage(hpToLose, target, source, this.dex.getActiveMove("bite"), true);

    this.add('-ability', source, 'Aftertaste');
    this.add(`-${source.name} consumed ${target.name}'s cursed energy!`);
  }
}