{
    onStart(pokemon) {
        if (!pokemon.beyondLimitlessEvadeBoosted) {
            pokemon.beyondLimitlessEvadeBoosted = true;
            this.boost({evasion: 6}, pokemon);
            this.add(`-${pokemon.name} activated Infinity and became untouchable!`);
        }
        pokemon.beyondLimitlessTargeted = false;
        pokemon.beyondLimitlessShouldDropEvasion = false;
    },

    onTryHit(target, source, move) {
        if (
            target === this.effectState.target &&
            !target.beyondLimitlessTargeted &&
            move.category !== 'Status'
        ) {
            target.beyondLimitlessTargeted = true;
            target.beyondLimitlessShouldDropEvasion = true;
        }
    },

    onResidual(pokemon) {
        if (pokemon.beyondLimitlessShouldDropEvasion) {
            pokemon.beyondLimitlessShouldDropEvasion = false;
            this.boost({evasion: -6}, pokemon);
            this.add(`-${pokemon.name}'s Infinity faded!`);
        }
    },

    onDamage(damage, target, source, effect) {
        if (effect && effect.effectType !== 'Move') {
            return false;
        }
    },

    onTryAddSideCondition(side, source, condition) {
        if (
            ['spikes', 'toxicspikes', 'stealthrock', 'stickyweb'].includes(condition.id) &&
            source && source.side !== side
        ) {
            this.add('-message', this.formatText('cobblemon.battle.beyondlimitless.hazardimmune', {
                side: side.name
            }));
            return null;
        }
    },

    name: 'Beyond Limitless',
    rating: 5,
    flags: { failroleplay: 1, noreceiver: 1, noentrain: 1, notrace: 1, failskillswap: 1, cantsuppress: 1 }
}