{
    onStart(pokemon) {
        if (pokemon.species.id === 'gojinja' && pokemon.getAbility().id === 'domainexpansion') {
            this.field.setTerrain('psychicterrain');
            this.add('-ability', pokemon, 'Domain Expansion');
            pokemon.addVolatile('domainexpansion');
        }
    },

    condition: {
        onModifySpA(spa, pokemon) {
            if (
                this.field.terrain === 'psychicterrain' &&
                pokemon.species.id === 'gojinja' &&
                pokemon.getAbility().id === 'domainexpansion'
            ) {
                return this.chainModify(1.2);
            }
        },

        onEnd(pokemon) {
            if (pokemon.getAbility().id === 'domainexpansion') {
                this.add('-end', pokemon, 'Domain Expansion');
            }
        },

        onFaint(pokemon) {
            if (pokemon.getAbility().id === 'domainexpansion') {
                pokemon.removeVolatile('domainexpansion');
            }
        },

        onSwitchOut(pokemon) {
            if (pokemon.getAbility().id === 'domainexpansion') {
                pokemon.removeVolatile('domainexpansion');
            }
        },
    },

    name: 'Domain Expansion',
    rating: 3,
    flags: { failroleplay: 1, noreceiver: 1, noentrain: 1, notrace: 1, failskillswap: 1, cantsuppress: 1 }
}