{
  onFoeTrapPokemon(pokemon) {
    const source = this.effectState.target;
    if (!source || !pokemon.isAdjacent(source)) return;

    if (pokemon.hasType("Dragon") || pokemon.hasType("Dark")) {
      pokemon.tryTrap(true);
      this.add(`-${pokemon.name} was lured in by ${source.name}'s glowing esca and can't escape!`);
    }
  },
  onFoeMaybeTrapPokemon(pokemon, source) {
    if (!source) source = this.effectState.target;
    if (!source || !pokemon.isAdjacent(source)) return;

    if (!pokemon.knownType || pokemon.hasType("Dragon") || pokemon.hasType("Dark")) {
      pokemon.maybeTrapped = true;
      this.add(`-${pokemon.name} might not escape ${source.name}'s esca glow...`);
    }
  },
  name: "Luring Esca",
  rating: 4
}