{
  onStart(pokemon) {
    pokemon.mealPrepReady = false;
  },

  onAfterMove(pokemon, target, move) {
    if (move?.category === 'Status' && move.flags?.heal) {
      pokemon.mealPrepReady = true;
      this.add(`-${pokemon.name} prepped a powerful strike after healing!`);
    } else if (move?.category !== 'Status') {
      if (pokemon.mealPrepReady) {
        this.add(`-${pokemon.name} served up the Meal Prep boost!`);
      }
      pokemon.mealPrepReady = false;
    }
  },

  onBasePower(basePower, attacker, defender, move) {
    if (attacker.mealPrepReady && move.category !== 'Status') {
      this.debug('Meal Prep boost applied');
      attacker.mealPrepReady = false;
      return this.chainModify(1.5);
    }
  },

  onSwitchOut(pokemon) {
    if (pokemon.mealPrepReady) {
      this.add(`-${pokemon.name}’s Meal Prep was canceled on switching out.`);
    }
    delete pokemon.mealPrepReady;
  },

  name: "Meal Prep",
  rating: 3
}